/*
 * Decompiled with CFR 0.152.
 */
package dev.kqmvs2.otherside;

import dev.kqmvs2.otherside.DespawnImmunityManager;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.world.EntitiesLoadEvent;

public class EntityListeners
implements Listener {
    private final DespawnImmunityManager despawnManager;

    public EntityListeners(DespawnImmunityManager despawnManager) {
        this.despawnManager = despawnManager;
    }

    @EventHandler
    public void on(EntityPortalEvent event) {
        LivingEntity livingEntity;
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).getRemoveWhenFarAway()) {
            this.despawnManager.setImmuneToHardDespawn(livingEntity, true);
            this.despawnManager.enqueueImmunityRemoval(livingEntity);
        }
    }

    @EventHandler
    public void on(EntitiesLoadEvent event) {
        for (Entity entity : event.getEntities()) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || (livingEntity = (LivingEntity)entity).getRemoveWhenFarAway()) continue;
            this.despawnManager.removeDespawnImmunityIfExpired((LivingEntity)entity);
        }
    }
}

