/*
 * Decompiled with CFR 0.152.
 */
package dev.kqmvs2.otherside;

import dev.kqmvs2.otherside.DespawnImmunityRemovalTask;
import dev.kqmvs2.otherside.Otherside;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Queue;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class DespawnImmunityManager {
    private final NamespacedKey HARD_DESPAWN_EXEMPT_SINCE_KEY;
    private final Queue<DespawnImmunityRemovalTask> exemptionRemovalTasks = new LinkedList<DespawnImmunityRemovalTask>();
    private final Otherside plugin;

    public DespawnImmunityManager(Otherside plugin) {
        this.HARD_DESPAWN_EXEMPT_SINCE_KEY = new NamespacedKey((Plugin)plugin, "hard-despawn-exempt-since");
        this.plugin = plugin;
    }

    public void setImmuneToHardDespawn(LivingEntity entity, boolean immune) {
        PersistentDataContainer pdc = entity.getPersistentDataContainer();
        if (immune) {
            if (!entity.getRemoveWhenFarAway()) {
                return;
            }
            long unixEpoch = System.currentTimeMillis() / 1000L;
            pdc.set(this.HARD_DESPAWN_EXEMPT_SINCE_KEY, PersistentDataType.LONG, (Object)unixEpoch);
            entity.setRemoveWhenFarAway(false);
        } else if (pdc.has(this.HARD_DESPAWN_EXEMPT_SINCE_KEY, PersistentDataType.LONG)) {
            pdc.remove(this.HARD_DESPAWN_EXEMPT_SINCE_KEY);
            entity.setRemoveWhenFarAway(true);
        }
    }

    public Optional<Instant> getHardDespawnImmuneSinceTimestamp(Entity entity) {
        PersistentDataContainer pdc = entity.getPersistentDataContainer();
        if (!pdc.has(this.HARD_DESPAWN_EXEMPT_SINCE_KEY, PersistentDataType.LONG)) {
            return Optional.empty();
        }
        long unixEpoch = (Long)pdc.get(this.HARD_DESPAWN_EXEMPT_SINCE_KEY, PersistentDataType.LONG);
        return Optional.of(Instant.ofEpochSecond(unixEpoch));
    }

    public void processPendingImmunityRemovalTasks() {
        DespawnImmunityRemovalTask task;
        while ((task = this.exemptionRemovalTasks.peek()) != null && task.isDue()) {
            this.setImmuneToHardDespawn(task.getEntity(), false);
            this.exemptionRemovalTasks.poll();
        }
    }

    public void removeDespawnImmunityIfExpired(LivingEntity entity) {
        this.getHardDespawnImmuneSinceTimestamp((Entity)entity).ifPresent(timestamp -> {
            long secondsElapsed = Duration.between(timestamp, Instant.now()).getSeconds();
            if (secondsElapsed >= (long)this.plugin.getOthersideConfig().getDespawnSeconds(entity.getType())) {
                this.setImmuneToHardDespawn(entity, false);
            }
        });
    }

    public void enqueueImmunityRemoval(LivingEntity entity) {
        Instant removalTimestamp = Instant.now().plusSeconds(this.plugin.getOthersideConfig().getDespawnSeconds(entity.getType()));
        this.exemptionRemovalTasks.add(new DespawnImmunityRemovalTask(entity, removalTimestamp));
    }
}

