/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.networks.terminals.inventory;

import de.kwantux.networks.Network;
import de.kwantux.networks.terminals.inventory.InventoryMenu;
import java.util.ArrayList;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class InventoryMenuManager {
    private static final ArrayList<InventoryMenu> list = new ArrayList();

    public static void updateMenus() {
        list.forEach(inventoryMenu -> inventoryMenu.updateInventory());
    }

    public static void addInventoryMenu(Player player, Network network) {
        list.add(new InventoryMenu(player, network));
    }

    public static void removeInventoryMenu(Player player) {
        InventoryMenu menu = InventoryMenuManager.getMenuForPlayer(player);
        if (menu != null) {
            menu.close();
            list.remove(menu);
        }
    }

    public static InventoryMenu getMenuForPlayer(Player player) {
        for (InventoryMenu inventoryMenu : list) {
            if (!inventoryMenu.player.equals((Object)player)) continue;
            return inventoryMenu;
        }
        return null;
    }

    public static void closeAll() {
        for (InventoryMenu menu : list) {
            menu.player.closeInventory();
        }
    }

    public static ArrayList<InventoryMenu> listInventoryMenus() {
        return list;
    }

    public static boolean isInventoryMenu(Inventory inventory) {
        for (InventoryMenu menu : list) {
            if (!menu.getInventory().equals((Object)inventory)) continue;
            return true;
        }
        return false;
    }
}

