/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.networks.terminals.inventory;

import de.kwantux.networks.Network;
import de.kwantux.networks.component.BasicComponent;
import de.kwantux.networks.terminals.component.TerminalComponent;
import de.kwantux.networks.terminals.util.Keys;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class InventoryMenu {
    Player player;
    Network network;
    private final Inventory inventory;
    private final ArrayList<ArrayList<ItemStack>> contents = new ArrayList();
    private int page;
    private BossBar bossBar;
    private final TerminalComponent component;

    public InventoryMenu(Player player, Network network) {
        this.player = player;
        this.network = network;
        this.component = new TerminalComponent(player);
        network.addComponent((BasicComponent)this.component);
        this.inventory = Bukkit.createInventory((InventoryHolder)player, (int)54, (Component)Component.text((String)("Content of network " + network.name())));
        this.inventory.setMaxStackSize(127);
        this.bossBar = BossBar.bossBar((Component)Component.text((String)("Network: " + network.name())), (float)1.0f, (BossBar.Color)BossBar.Color.BLUE, (BossBar.Overlay)BossBar.Overlay.PROGRESS);
        this.bossBar.addViewer((Audience)player);
        this.updateInventory();
        this.renderInventory();
        player.openInventory(this.inventory);
    }

    public void close() {
        this.bossBar.removeViewer((Audience)this.player);
        this.network.removeComponent((BasicComponent)this.component);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public Network getNetwork() {
        return this.network;
    }

    public TerminalComponent getComponent() {
        return this.component;
    }

    private void addControls() {
        ItemStack first = new ItemStack(Material.SPECTRAL_ARROW);
        ItemMeta itemMeta = first.getItemMeta();
        itemMeta.displayName((Component)Component.text((String)"<<--"));
        itemMeta.getPersistentDataContainer().set(Keys.NETWORKS_MENU_ICON, PersistentDataType.INTEGER, (Object)1);
        first.setItemMeta(itemMeta);
        ItemStack back = new ItemStack(Material.ARROW);
        itemMeta = back.getItemMeta();
        itemMeta.displayName((Component)Component.text((String)"<-"));
        itemMeta.getPersistentDataContainer().set(Keys.NETWORKS_MENU_ICON, PersistentDataType.INTEGER, (Object)2);
        back.setItemMeta(itemMeta);
        ItemStack forward = new ItemStack(Material.ARROW);
        itemMeta = forward.getItemMeta();
        itemMeta.displayName((Component)Component.text((String)"->"));
        itemMeta.getPersistentDataContainer().set(Keys.NETWORKS_MENU_ICON, PersistentDataType.INTEGER, (Object)3);
        forward.setItemMeta(itemMeta);
        ItemStack last = new ItemStack(Material.SPECTRAL_ARROW);
        itemMeta = last.getItemMeta();
        itemMeta.displayName((Component)Component.text((String)"-->>"));
        itemMeta.getPersistentDataContainer().set(Keys.NETWORKS_MENU_ICON, PersistentDataType.INTEGER, (Object)4);
        last.setItemMeta(itemMeta);
        this.inventory.setItem(45, first);
        this.inventory.setItem(46, back);
        this.inventory.setItem(52, forward);
        this.inventory.setItem(53, last);
    }

    public void updateInventory() {
        this.contents.clear();
        ArrayList<ItemStack> currentPage = new ArrayList<ItemStack>();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(this.network.items().stream().filter(Objects::nonNull).toList());
        items.sort(Comparator.comparing(ItemStack::getAmount).reversed());
        items.sort(Comparator.comparing(ItemStack::getType));
        for (ItemStack item : items) {
            if (item != null) {
                currentPage.add(item);
            }
            if (currentPage.size() != 45) continue;
            this.contents.add(currentPage);
            currentPage = new ArrayList();
        }
        this.contents.add(currentPage);
    }

    public void renderInventory() {
        this.inventory.setContents(this.contents.get(this.page).toArray(new ItemStack[54]));
        this.addControls();
        this.bossBar.progress((float)(this.page + 1) / (float)this.contents.size());
    }

    public void toFirstPage() {
        this.page = 0;
        this.renderInventory();
    }

    public void incrementPage() {
        if (this.page < this.contents.size() - 1) {
            ++this.page;
        }
        this.renderInventory();
    }

    public void decrementPage() {
        if (this.page > 0) {
            --this.page;
        }
        this.renderInventory();
    }

    public void toLastPage() {
        this.page = this.contents.size() - 1;
        this.renderInventory();
    }
}

