/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.networks.terminals.event;

import de.kwantux.networks.Network;
import de.kwantux.networks.Sorter;
import de.kwantux.networks.component.module.ActiveModule;
import de.kwantux.networks.terminals.TerminalsPlugin;
import de.kwantux.networks.terminals.inventory.InventoryMenu;
import de.kwantux.networks.terminals.inventory.InventoryMenuManager;
import de.kwantux.networks.terminals.util.Keys;
import de.kwantux.networks.utils.PositionedItemStack;
import de.kwantux.networks.utils.Transaction;
import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class InventoryMenuListener
implements Listener {
    public InventoryMenuListener(TerminalsPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    private void scheduleUpdate(InventoryMenu menu) {
        menu.updateInventory();
        Bukkit.getScheduler().runTaskLater((Plugin)TerminalsPlugin.instance, menu::renderInventory, 1L);
    }

    private boolean handleClick(Player player, Inventory inventory, InventoryMenu menu, InventoryAction action, ItemStack currentItem, ItemStack cursor) {
        if (currentItem != null && currentItem.getItemMeta() != null && currentItem.getItemMeta().getPersistentDataContainer().has(Keys.NETWORKS_MENU_ICON, PersistentDataType.INTEGER)) {
            Integer n = (Integer)currentItem.getItemMeta().getPersistentDataContainer().get(Keys.NETWORKS_MENU_ICON, PersistentDataType.INTEGER);
            int n2 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{1, 2, 3, 4}, (Object)n, n2)) {
                case 0: {
                    menu.toFirstPage();
                    return true;
                }
                case 1: {
                    menu.decrementPage();
                    return true;
                }
                case 2: {
                    menu.incrementPage();
                    return true;
                }
                case 3: {
                    menu.toLastPage();
                    return true;
                }
            }
            return true;
        }
        switch (action) {
            case PLACE_ONE: {
                if (inventory != null && inventory.equals((Object)player.getInventory())) {
                    return false;
                }
                assert (cursor != null);
                ItemStack toTransmit = cursor.clone();
                toTransmit.setAmount(1);
                Set transactions = Sorter.tryDonation((Network)menu.getNetwork(), (ActiveModule)menu.getComponent(), Set.of(new PositionedItemStack(toTransmit, null, 0)));
                Iterator iterator = transactions.iterator();
                if (iterator.hasNext()) {
                    Transaction transaction = (Transaction)iterator.next();
                    Sorter.addItem((Transaction)transaction);
                    this.scheduleUpdate(menu);
                    return false;
                }
                return true;
            }
            case PLACE_ALL: {
                if (inventory != null && inventory.equals((Object)player.getInventory())) {
                    return false;
                }
                assert (cursor != null);
                Set transactions0 = Sorter.tryDonation((Network)menu.getNetwork(), (ActiveModule)menu.getComponent(), Set.of(new PositionedItemStack(cursor, null, 0)));
                Iterator transaction = transactions0.iterator();
                if (transaction.hasNext()) {
                    Transaction transaction2 = (Transaction)transaction.next();
                    Sorter.addItem((Transaction)transaction2);
                    this.scheduleUpdate(menu);
                    return false;
                }
                return true;
            }
            case COLLECT_TO_CURSOR: 
            case PICKUP_ALL: 
            case DROP_ALL_SLOT: {
                if (inventory != null && inventory.equals((Object)player.getInventory())) {
                    return false;
                }
                assert (currentItem != null);
                Set transactions1 = Sorter.tryRequest((Network)menu.getNetwork(), (ActiveModule)menu.getComponent(), Set.of(new PositionedItemStack(currentItem, null, 0)));
                Iterator transaction2 = transactions1.iterator();
                if (transaction2.hasNext()) {
                    Transaction transaction = (Transaction)transaction2.next();
                    Sorter.removeItem((Transaction)transaction);
                    this.scheduleUpdate(menu);
                    return false;
                }
                return true;
            }
            case PICKUP_HALF: {
                if (inventory != null && inventory.equals((Object)player.getInventory())) {
                    return false;
                }
                assert (currentItem != null);
                ItemStack toTransmit1 = currentItem.clone();
                toTransmit1.setAmount(Math.ceilDiv(currentItem.getAmount(), 2));
                Set transactions2 = Sorter.tryRequest((Network)menu.getNetwork(), (ActiveModule)menu.getComponent(), Set.of(new PositionedItemStack(toTransmit1, null, 0)));
                Iterator iterator = transactions2.iterator();
                if (iterator.hasNext()) {
                    Transaction transaction = (Transaction)iterator.next();
                    Sorter.removeItem((Transaction)transaction);
                    this.scheduleUpdate(menu);
                    return false;
                }
                return true;
            }
            case PICKUP_ONE: 
            case DROP_ONE_SLOT: {
                if (inventory != null && inventory.equals((Object)player.getInventory())) {
                    return false;
                }
                assert (currentItem != null);
                ItemStack toTransmit2 = currentItem.clone();
                toTransmit2.setAmount(1);
                Set transactions2a = Sorter.tryRequest((Network)menu.getNetwork(), (ActiveModule)menu.getComponent(), Set.of(new PositionedItemStack(toTransmit2, null, 0)));
                Iterator iterator = transactions2a.iterator();
                if (iterator.hasNext()) {
                    Transaction transaction = (Transaction)iterator.next();
                    Sorter.removeItem((Transaction)transaction);
                    this.scheduleUpdate(menu);
                    return false;
                }
                return true;
            }
            case MOVE_TO_OTHER_INVENTORY: {
                Set transactions3;
                Iterator transaction;
                assert (currentItem != null);
                if (inventory.equals((Object)player.getInventory()) && (transaction = (transactions3 = Sorter.tryDonation((Network)menu.getNetwork(), (ActiveModule)menu.getComponent(), Set.of(new PositionedItemStack(currentItem, null, 0)))).iterator()).hasNext()) {
                    Transaction transaction3 = (Transaction)transaction.next();
                    Sorter.addItem((Transaction)transaction3);
                    this.scheduleUpdate(menu);
                    return false;
                }
                if (inventory.equals((Object)menu.getInventory()) && (transaction = (transactions3 = Sorter.tryRequest((Network)menu.getNetwork(), (ActiveModule)menu.getComponent(), Set.of(new PositionedItemStack(currentItem, null, 0)))).iterator()).hasNext()) {
                    Transaction transaction4 = (Transaction)transaction.next();
                    Sorter.removeItem((Transaction)transaction4);
                    this.scheduleUpdate(menu);
                    return false;
                }
                return true;
            }
            case SWAP_WITH_CURSOR: {
                Transaction addition = null;
                Transaction removal = null;
                Set transactions4 = Sorter.tryDonation((Network)menu.getNetwork(), (ActiveModule)menu.getComponent(), Set.of(new PositionedItemStack(cursor, null, 0)));
                Iterator iterator = transactions4.iterator();
                while (iterator.hasNext()) {
                    Transaction transaction;
                    addition = transaction = (Transaction)iterator.next();
                }
                Set transactions5 = Sorter.tryRequest((Network)menu.getNetwork(), (ActiveModule)menu.getComponent(), Set.of(new PositionedItemStack(currentItem, null, 0)));
                Iterator iterator2 = transactions5.iterator();
                while (iterator2.hasNext()) {
                    Transaction transaction;
                    removal = transaction = (Transaction)iterator2.next();
                }
                if (addition != null && removal != null) {
                    Sorter.removeItem((Transaction)removal);
                    Sorter.addItem((Transaction)addition);
                    this.scheduleUpdate(menu);
                    return false;
                }
                return true;
            }
            case HOTBAR_SWAP: {
                return true;
            }
            case NOTHING: 
            case CLONE_STACK: 
            case DROP_ALL_CURSOR: 
            case DROP_ONE_CURSOR: {
                return false;
            }
        }
        return true;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onInventoryDrag(InventoryDragEvent event) {
        Player player = (Player)event.getWhoClicked();
        InventoryMenu menu = InventoryMenuManager.getMenuForPlayer(player);
        if (menu == null) {
            return;
        }
        if (event.getInventory() != menu.getInventory()) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onInventoryClicked(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        InventoryMenu menu = InventoryMenuManager.getMenuForPlayer(player);
        if (menu == null) {
            return;
        }
        try {
            event.setCancelled(this.handleClick(player, event.getClickedInventory(), menu, event.getAction(), event.getCurrentItem(), event.getCursor()));
        }
        catch (Exception ignored) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (InventoryMenuManager.isInventoryMenu(event.getInventory())) {
            InventoryMenuManager.removeInventoryMenu((Player)event.getPlayer());
        }
    }
}

