/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.networks.terminals.commands;

import de.kwantux.config.util.exceptions.InvalidNodeException;
import de.kwantux.networks.Main;
import de.kwantux.networks.terminals.TerminalsPlugin;
import de.kwantux.networks.terminals.commands.CommandHandler;
import de.kwantux.networks.terminals.commands.InterfaceCommand;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.caption.Caption;
import org.incendo.cloud.caption.CaptionProvider;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.paper.LegacyPaperCommandManager;
import org.incendo.cloud.parser.ParserRegistry;

public final class TerminalsCommandManager {
    private LegacyPaperCommandManager<CommandSender> commandManager;
    private ParserRegistry<CommandSender> parsers;

    public TerminalsCommandManager(TerminalsPlugin plugin) {
        this.commandManager = LegacyPaperCommandManager.createNative((Plugin)plugin, (ExecutionCoordinator)ExecutionCoordinator.simpleCoordinator());
        this.parsers = this.commandManager.parserRegistry();
        this.commandManager.captionRegistry().registerProvider(CaptionProvider.forCaption((Caption)Caption.of((String)"argument.parse.failure.network"), sender -> {
            try {
                return Main.lang.getRaw("invalidnetwork");
            }
            catch (InvalidNodeException e) {
                return "No such network: <input>";
            }
        }));
        this.commandManager.captionRegistry().registerProvider(CaptionProvider.forCaption((Caption)Caption.of((String)"argument.parse.failure.componenttype"), sender -> "No such component type: <input>"));
        List.of(new InterfaceCommand(plugin, (CommandManager<CommandSender>)this.commandManager)).forEach(CommandHandler::register);
    }
}

