/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.networks.utils;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class PositionedItemStack
extends ItemStack {
    private final Inventory inventory;
    private final int slot;

    public PositionedItemStack(@Nonnull ItemStack stack, @Nullable Inventory inventory, int slot) {
        super(stack);
        this.inventory = inventory;
        this.slot = slot;
    }

    @Nullable
    public Inventory inventory() {
        return this.inventory;
    }

    public int slot() {
        return this.slot;
    }

    public int hashCode() {
        return super.hashCode() + (this.inventory == null ? 0 : this.inventory.hashCode()) + this.slot;
    }

    public static Set<PositionedItemStack> fromInventory(@Nullable Inventory inventory) {
        HashSet<PositionedItemStack> stacks = new HashSet<PositionedItemStack>();
        if (inventory == null) {
            return stacks;
        }
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack == null) continue;
            stacks.add(new PositionedItemStack(stack, inventory, i));
        }
        return stacks;
    }
}

