/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.networks.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.kwantux.networks.Main;
import de.kwantux.networks.Network;
import de.kwantux.networks.compat.LegacyNetwork;
import de.kwantux.networks.component.BasicComponent;
import de.kwantux.networks.config.Config;
import de.kwantux.networks.storage.ComponentSerializer;
import de.kwantux.networks.storage.OriginSerializer;
import de.kwantux.networks.storage.SerializableNetwork;
import de.kwantux.networks.utils.Origin;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Storage {
    private static final Logger log = LoggerFactory.getLogger(Storage.class);
    private final Main plugin;
    private final Path path;
    public static final Gson gson;

    public Storage(Main plugin) {
        this.plugin = plugin;
        plugin.getDataFolder().mkdirs();
        this.path = plugin.getDataFolder().toPath().resolve("networks");
    }

    public boolean create(String id, UUID owner) {
        if (!Network.validName(id)) {
            return false;
        }
        if (this.path.resolve(id + ".json").toFile().exists()) {
            return false;
        }
        this.saveNetwork(id, new Network(id, owner));
        return true;
    }

    public void delete(String id) {
        try {
            if (Config.archiveNetworksOnDelete) {
                Files.createDirectories(this.path.resolve("archive"), new FileAttribute[0]);
                Files.move(this.path.resolve(id + ".json"), this.path.resolve("archive/" + id + "-" + LocalDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME) + ".json"), StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.delete(this.path.resolve(id + ".json"));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public Network loadNetwork(String id) {
        try {
            String json = Files.readString(this.path.resolve(id + ".json"), StandardCharsets.UTF_8);
            try {
                return new Network(id, (SerializableNetwork)gson.fromJson(json, SerializableNetwork.class));
            }
            catch (RuntimeException e) {
                try {
                    Network network = ((LegacyNetwork)gson.fromJson(json, LegacyNetwork.class)).convert(id);
                    this.saveNetwork(id, network);
                    return network;
                }
                catch (RuntimeException ignored) {
                    Main.logger.warning("Unable to load Network with ID " + id + "\nThe network file is likely corrupted. Skipping...");
                    e.printStackTrace();
                    return null;
                }
            }
        }
        catch (IOException e) {
            Main.logger.warning("Unable to load Network with ID " + id + "\nThis is likely due to incorrectly set file permissions. Skipping...");
            return null;
        }
    }

    public boolean renameNetwork(String id, String newName) {
        if (this.path.resolve(newName + ".json").toFile().exists()) {
            return false;
        }
        try {
            Files.move(this.path.resolve(id + ".json"), this.path.resolve(newName + ".json"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public Set<String> getNetworkIDs() {
        try {
            HashSet<String> set = new HashSet<String>();
            Files.list(this.path).forEach(file -> {
                if (file.toString().endsWith(".json")) {
                    set.add(file.getFileName().toString().replace(".json", ""));
                }
            });
            return set;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void saveNetwork(String id, Network network) {
        SerializableNetwork serializable = new SerializableNetwork(network);
        String json = gson.toJson((Object)serializable);
        try {
            Files.write(this.path.resolve(id + ".json"), json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(BasicComponent.class, (Object)new ComponentSerializer());
        builder.registerTypeAdapter(Origin.class, (Object)new OriginSerializer());
        if (Config.humanReadableJson) {
            builder.setPrettyPrinting();
        }
        gson = builder.create();
    }
}

