/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.networks.event;

import de.kwantux.networks.Main;
import de.kwantux.networks.Network;
import de.kwantux.networks.component.util.ComponentType;
import de.kwantux.networks.utils.BlockLocation;
import de.kwantux.networks.utils.NamespaceUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ComponentInstallListener
implements Listener {
    public ComponentInstallListener(Main plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onComponentInstall(PlayerInteractEvent event) {
        if (!event.isCancelled()) {
            if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
                return;
            }
            if (event.getClickedBlock() == null) {
                return;
            }
            Player p = event.getPlayer();
            BlockLocation pos = new BlockLocation(event.getClickedBlock());
            Network network = Main.mgr.selection((CommandSender)p);
            ItemStack item = event.getItem();
            if (item == null) {
                return;
            }
            if (item.getType().isBlock()) {
                return;
            }
            PersistentDataContainer container = item.getItemMeta().getPersistentDataContainer();
            ComponentType type = ComponentType.get((String)container.get(NamespaceUtils.COMPONENT.key(), PersistentDataType.STRING));
            if (type == null) {
                return;
            }
            event.setCancelled(true);
            if (Main.mgr.getComponent(pos) != null) {
                Main.lang.message((CommandSender)p, "location.occupied");
                return;
            }
            if (Main.cfg.checkLocation(pos, type)) {
                if (network == null) {
                    Main.lang.message((CommandSender)p, "select.noselection");
                    event.setCancelled(true);
                    return;
                }
                Main.mgr.createComponent(network, type, pos, container);
                item.setAmount(item.getAmount() - 1);
                Main.lang.message((CommandSender)p, "component." + type.tag + ".add", network.name(), pos.toString());
            }
        }
    }
}

