/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.networks.component.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;

public class FilterTranslator {
    private static Path path = null;
    private static final Map<Integer, Component> translations = new HashMap<Integer, Component>();

    public static Component translate(int id) {
        return (Component)Objects.requireNonNullElse(translations.get(id), Component.text((String)("#" + id)));
    }

    public static boolean hasTranslation(int id) {
        return translations.containsKey(id);
    }

    public static void updateTranslation(int id, Component translation) {
        translations.put(id, translation);
    }

    public static void save() throws IOException {
        if (path == null) {
            return;
        }
        List lines = translations.entrySet().stream().map(e -> String.valueOf(e.getKey()) + "\t" + (String)MiniMessage.miniMessage().serialize((Component)e.getValue())).distinct().collect(Collectors.toList());
        Files.write(path, lines, new OpenOption[0]);
    }

    public static void load(Path filePath) throws IOException {
        path = filePath;
        try {
            for (String line : Files.readAllLines(filePath)) {
                String[] split = line.split("\t");
                try {
                    int id = Integer.parseInt(split[0]);
                    Component translation = MiniMessage.miniMessage().deserialize((Object)split[1]);
                    translations.put(id, translation);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }
}

