/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.networks.component;

import de.kwantux.networks.component.InstallableComponent;
import de.kwantux.networks.component.util.ComponentType;
import de.kwantux.networks.config.Config;
import de.kwantux.networks.utils.BlockLocation;
import de.kwantux.networks.utils.Origin;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.Nullable;

public abstract class BlockComponent
extends InstallableComponent {
    protected BlockLocation pos;

    @Override
    public abstract ComponentType type();

    protected BlockComponent(BlockLocation pos) {
        this.pos = pos;
    }

    public BlockLocation pos() {
        return this.pos;
    }

    @Override
    public Origin origin() {
        return this.pos;
    }

    public boolean isLoaded() {
        World world = Bukkit.getWorld((UUID)this.pos.getWorld());
        return world != null && world.isChunkLoaded(this.pos.getX() >> 4, this.pos.getZ() >> 4);
    }

    public boolean ready() {
        return Config.loadChunks || this.isLoaded();
    }

    @Override
    @Nullable
    public Inventory inventory() {
        if (!this.ready()) {
            return null;
        }
        Block block = Bukkit.getWorld((UUID)this.pos.getWorld()).getBlockAt(this.pos.getX(), this.pos.getY(), this.pos.getZ());
        if (block.getState() instanceof InventoryHolder) {
            return ((InventoryHolder)block.getState()).getInventory();
        }
        return null;
    }
}

