/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.networks.component;

import de.kwantux.networks.component.util.ComponentType;
import de.kwantux.networks.utils.NamespaceUtils;
import de.kwantux.networks.utils.Origin;
import java.util.Map;
import org.bukkit.inventory.Inventory;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public abstract class BasicComponent {
    public abstract ComponentType type();

    public abstract Origin origin();

    public abstract Map<String, Object> properties();

    public boolean isMissingData() {
        return false;
    }

    public abstract Inventory inventory();

    public static void mapToContainer(PersistentDataContainer container, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                container.set(NamespaceUtils.key(key), PersistentDataType.STRING, (Object)((String)value));
                continue;
            }
            if (value instanceof Integer) {
                container.set(NamespaceUtils.key(key), PersistentDataType.INTEGER, (Object)((Integer)value));
                continue;
            }
            if (value instanceof Long) {
                container.set(NamespaceUtils.key(key), PersistentDataType.LONG, (Object)((Long)value));
                continue;
            }
            if (value instanceof Double) {
                container.set(NamespaceUtils.key(key), PersistentDataType.DOUBLE, (Object)((Double)value));
                continue;
            }
            if (value instanceof Float) {
                container.set(NamespaceUtils.key(key), PersistentDataType.FLOAT, (Object)Float.valueOf(((Float)value).floatValue()));
                continue;
            }
            if (value instanceof Short) {
                container.set(NamespaceUtils.key(key), PersistentDataType.SHORT, (Object)((Short)value));
                continue;
            }
            if (value instanceof Byte) {
                container.set(NamespaceUtils.key(key), PersistentDataType.BYTE, (Object)((Byte)value));
                continue;
            }
            if (value instanceof Boolean) {
                container.set(NamespaceUtils.key(key), PersistentDataType.BYTE, (Object)((Boolean)value != false ? (byte)1 : 0));
                continue;
            }
            if (value instanceof int[]) {
                container.set(NamespaceUtils.key(key), PersistentDataType.INTEGER_ARRAY, (Object)((int[])value));
                continue;
            }
            if (value instanceof long[]) {
                container.set(NamespaceUtils.key(key), PersistentDataType.LONG_ARRAY, (Object)((long[])value));
                continue;
            }
            if (value instanceof byte[]) {
                container.set(NamespaceUtils.key(key), PersistentDataType.BYTE_ARRAY, (Object)((byte[])value));
                continue;
            }
            throw new IllegalArgumentException("Unsupported value type: " + String.valueOf(value.getClass()) + " for key: " + key + " and value: " + String.valueOf(value) + "\nPlease report this to the networks developers / developers of networks addons");
        }
    }
}

