/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.networks.commands;

import de.kwantux.networks.Main;
import de.kwantux.networks.Network;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.caption.Caption;
import org.incendo.cloud.caption.CaptionVariable;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.exception.parsing.ParserException;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.parser.ParserDescriptor;
import org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import org.jetbrains.annotations.NotNull;

public final class NetworkParser
implements ArgumentParser<CommandSender, Network>,
BlockingSuggestionProvider.Strings<CommandSender> {
    public static @NonNull ParserDescriptor<CommandSender, Network> networkParser() {
        return ParserDescriptor.of((ArgumentParser)new NetworkParser(), Network.class);
    }

    @NotNull
    public ArgumentParseResult<Network> parse(@NotNull CommandContext<CommandSender> context, @NotNull CommandInput inputQueue) {
        String input = inputQueue.readString();
        Network network = Main.mgr.getFromName(input);
        if (network == null) {
            return ArgumentParseResult.failure((Throwable)((Object)new NetworkParseException(input, context)));
        }
        return ArgumentParseResult.success((Object)network);
    }

    @NotNull
    public @NotNull List<@NotNull String> stringSuggestions(@NotNull CommandContext<CommandSender> commandContext, @NotNull CommandInput input) {
        ArrayList<String> output = new ArrayList<String>();
        if (commandContext.sender() instanceof Player) {
            for (Network network : Main.mgr.withUser(((Player)commandContext.sender()).getUniqueId())) {
                output.add(network.name());
            }
        } else {
            for (Network network : Main.mgr.getNetworks()) {
                output.add(network.name());
            }
        }
        return output;
    }

    public static final class NetworkParseException
    extends ParserException {
        private final String input;

        public NetworkParseException(@NotNull String input, @NotNull CommandContext<?> context) {
            super(NetworkParser.class, context, Caption.of((String)"argument.parse.failure.network"), new CaptionVariable[]{CaptionVariable.of((String)"input", (String)input)});
            this.input = input;
        }

        @NotNull
        public String getInput() {
            return this.input;
        }
    }
}

