/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.networks;

import de.kwantux.networks.Main;
import de.kwantux.networks.Network;
import de.kwantux.networks.component.module.Acceptor;
import de.kwantux.networks.component.module.ActiveModule;
import de.kwantux.networks.component.module.BaseModule;
import de.kwantux.networks.component.module.Donator;
import de.kwantux.networks.component.module.Requestor;
import de.kwantux.networks.component.module.Supplier;
import de.kwantux.networks.config.Config;
import de.kwantux.networks.utils.FoliaUtils;
import de.kwantux.networks.utils.PositionedItemStack;
import de.kwantux.networks.utils.Transaction;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import org.bukkit.inventory.ItemStack;

public class Sorter {
    public static synchronized void transmit(@Nonnull Transaction transaction) {
        if (transaction.target().spaceFree(transaction.stack()) && Sorter.removeItem(transaction)) {
            Sorter.addItemNoCheck(transaction);
        }
    }

    private static synchronized void addItemNoCheck(Transaction transaction) {
        transaction.target().inventory().addItem(new ItemStack[]{transaction.stack()});
    }

    public static synchronized boolean addItem(Transaction transaction) {
        if (!transaction.target().spaceFree(transaction.stack())) {
            return false;
        }
        Sorter.addItemNoCheck(transaction);
        return true;
    }

    public static synchronized boolean removeItem(Transaction transaction) {
        boolean itemExists = Sorter.containsRequestedStack(transaction.source().inventory().getStorageContents(), (ItemStack)transaction.stack());
        if (!itemExists) {
            return false;
        }
        transaction.source().inventory().removeItem(new ItemStack[]{transaction.stack()});
        return true;
    }

    public static synchronized void donate(Network network, Donator donator) {
        Sorter.donate(network, donator, donator.donate());
    }

    public static synchronized void donate(Network network, ActiveModule source, Set<PositionedItemStack> items) {
        for (Transaction transaction2 : Sorter.tryDonation(network, source, items).stream().sorted(Comparator.comparingInt(transaction -> transaction.stack().getAmount()).reversed()).toList()) {
            Sorter.transmit(transaction2);
        }
    }

    public static synchronized Set<Transaction> tryDonation(Network network, ActiveModule source, Set<PositionedItemStack> items) {
        HashSet<Transaction> transactions = new HashSet<Transaction>();
        for (PositionedItemStack item : items) {
            if (item == null) continue;
            for (Acceptor acceptor : network.acceptors()) {
                if (!acceptor.ready() || !Sorter.inDistance(network, source, acceptor) || !acceptor.accept(item) || !acceptor.spaceFree(item)) continue;
                transactions.add(new Transaction(source, acceptor, item));
            }
        }
        return transactions;
    }

    public static synchronized void request(Network network, Requestor requestor) {
        Sorter.request(network, requestor, requestor.requested());
    }

    public static synchronized void request(Network network, ActiveModule target, Set<PositionedItemStack> items) {
        for (Transaction transaction2 : Sorter.tryRequest(network, target, items).stream().sorted(Comparator.comparingInt(transaction -> transaction.stack().getAmount()).reversed()).toList()) {
            Sorter.transmit(transaction2);
        }
    }

    public static synchronized Set<Transaction> tryRequest(Network network, ActiveModule target, Set<PositionedItemStack> items) {
        HashSet<Transaction> transactions = new HashSet<Transaction>();
        List<? extends Supplier> suppliers = network.suppliers();
        for (PositionedItemStack item : items) {
            if (item == null) continue;
            try {
                for (Supplier supplier : suppliers) {
                    if (!supplier.ready() || !Sorter.inDistance(network, target, supplier) || !Sorter.containsRequestedStack(supplier.supply(), (ItemStack)item)) continue;
                    transactions.add(new Transaction(supplier, target, item));
                }
            }
            catch (Throwable e) {
                if (!FoliaUtils.folia) {
                    Main.logger.severe("Failed to sort item: " + e.getMessage());
                    e.printStackTrace();
                    continue;
                }
                Main.logger.log(Level.FINER, "Failed to sort item (this will be regularly thrown if Folia is used): " + e.getMessage());
            }
        }
        return transactions;
    }

    public static boolean inDistance(Network network, ActiveModule active, BaseModule passive) {
        return active.range() < 0 || active.range() >= Config.ranges.length || Config.ranges[Math.min(active.range(), Config.ranges.length - 1)] < 1 || active.pos().getDistance(passive.pos()) <= (double)(Config.ranges[Math.min(active.range(), Config.ranges.length - 1)] + network.range());
    }

    public static boolean containsRequestedStack(List<ItemStack> stacks, ItemStack requested) {
        for (ItemStack stack : stacks) {
            if (stack == null || !stack.isSimilar(requested) || stack.getAmount() < requested.getAmount()) continue;
            return true;
        }
        return false;
    }

    public static boolean containsRequestedStack(ItemStack[] stacks, ItemStack requested) {
        for (ItemStack stack : stacks) {
            if (stack == null || !stack.isSimilar(requested) || stack.getAmount() < requested.getAmount()) continue;
            return true;
        }
        return false;
    }
}

