/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.config.lang;

import de.kwantux.config.lang.Language;
import de.kwantux.config.util.exceptions.InvalidNodeException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.serialize.SerializationException;

public class LanguageController {
    private final JavaPlugin plugin;
    private final Logger logger;
    private final MiniMessage mm;
    private final List<Language> languages = new ArrayList<Language>();

    public LanguageController(JavaPlugin plugin, String ... order) {
        File[] files;
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.mm = MiniMessage.miniMessage();
        ArrayList<String> orderString = new ArrayList<String>();
        for (String key : order) {
            try {
                if (orderString.contains(key)) continue;
                this.languages.add(new Language(plugin, key));
                orderString.add(key);
            }
            catch (SerializationException e) {
                this.logger.severe("[QC] Language file " + key + ".yml does not exist!");
            }
        }
        for (File file : files = new File(plugin.getDataFolder(), "lang/").listFiles()) {
            try {
                String key = file.getName().toLowerCase().replaceAll(".yml", "");
                if (orderString.contains(key)) continue;
                this.languages.add(new Language(plugin, key));
                orderString.add(key);
            }
            catch (SerializationException serializationException) {
                // empty catch block
            }
        }
        Collections.reverse(this.languages);
        this.logger.info("[QC] Launched using language order: " + String.valueOf(orderString));
    }

    public String getRaw(@NotNull String path) throws InvalidNodeException {
        String result = null;
        for (Language language : this.languages) {
            if (!language.has(path)) continue;
            result = language.getRaw(path);
        }
        if (result != null) {
            return result;
        }
        throw new InvalidNodeException("[QC] No language file with language key " + path + " found!");
    }

    public Component get(String path) throws InvalidNodeException {
        return this.mm.deserialize((Object)this.getPreparedString(path));
    }

    public Component getFinal(String path) {
        try {
            return this.mm.deserialize((Object)this.getPreparedString(path));
        }
        catch (InvalidNodeException e) {
            this.logger.severe("Invalid language key: " + path);
            return Component.text((String)(this.plugin.getName() + "." + path));
        }
    }

    public Component get(String path, Component ... replacements) throws InvalidNodeException {
        ArrayList<TagResolver.Single> resolvers = new ArrayList<TagResolver.Single>();
        for (int i = 0; i < replacements.length; ++i) {
            resolvers.add(Placeholder.component((String)String.valueOf(i + 1), (ComponentLike)replacements[i]));
        }
        return this.mm.deserialize(this.getPreparedString(path), resolvers.toArray(new TagResolver[replacements.length]));
    }

    public Component get(String path, TagResolver ... replacements) throws InvalidNodeException {
        return this.mm.deserialize(this.getPreparedString(path), replacements);
    }

    public Component get(String path, String ... replacements) throws InvalidNodeException {
        ArrayList<TagResolver.Single> resolvers = new ArrayList<TagResolver.Single>();
        for (int i = 0; i < replacements.length; ++i) {
            resolvers.add(Placeholder.component((String)String.valueOf(i + 1), (ComponentLike)Component.text((String)replacements[i])));
        }
        return this.mm.deserialize(this.getPreparedString(path), resolvers.toArray(new TagResolver[replacements.length]));
    }

    @NotNull
    private String getPreparedString(@NotNull String path) throws InvalidNodeException {
        String result = null;
        for (Language language : this.languages) {
            if (!language.has(path)) continue;
            result = language.getPreparedString(path);
        }
        if (result != null) {
            return result;
        }
        throw new InvalidNodeException("[QC] No language file with language key " + path + " found!");
    }

    @Nullable
    public List<String> getList(@NotNull String path) throws InvalidNodeException {
        List<String> result = null;
        for (Language language : this.languages) {
            if (!language.has(path)) continue;
            result = language.getList(path);
        }
        if (result != null) {
            return result;
        }
        throw new InvalidNodeException("[QC] No language file with language key " + path + " found!");
    }

    @Nullable
    public Component getItemName(@NotNull String path) throws InvalidNodeException {
        return this.get("item.name." + path).decoration(TextDecoration.ITALIC, false);
    }

    public List<Component> getItemLore(String path) throws InvalidNodeException {
        List<String> list = this.getList("item.lore." + path);
        ArrayList<Component> result = new ArrayList<Component>();
        for (String s : list) {
            result.add(this.mm.deserialize((Object)s).decoration(TextDecoration.ITALIC, false));
        }
        return result;
    }

    private Component invalidKeyError(String key) {
        return ((TextComponent)((TextComponent)((TextComponent)Component.text((String)"[QC]").color(TextColor.color((int)0, (int)255, (int)100))).append(Component.text((String)" Invalid language key ").color(TextColor.color((int)255, (int)30, (int)30)))).append(Component.text((String)key).color(TextColor.color((int)255, (int)255, (int)255)))).append(Component.text((String)" not found in any language file!").color(TextColor.color((int)255, (int)30, (int)30)));
    }

    public boolean message(CommandSender receiver, String key) {
        try {
            receiver.sendMessage(this.get(key));
            return true;
        }
        catch (InvalidNodeException e) {
            receiver.sendMessage(this.invalidKeyError(key));
            return false;
        }
    }

    public boolean message(CommandSender receiver, String key, Component ... replacements) {
        try {
            receiver.sendMessage(this.get(key, replacements));
            return true;
        }
        catch (InvalidNodeException e) {
            receiver.sendMessage(this.invalidKeyError(key));
            return false;
        }
    }

    public boolean message(CommandSender receiver, String key, String ... replacements) {
        try {
            receiver.sendMessage(this.get(key, replacements));
            return true;
        }
        catch (InvalidNodeException e) {
            receiver.sendMessage(this.invalidKeyError(key));
            return false;
        }
    }

    public boolean message(CommandSender receiver, String key, TagResolver ... replacements) {
        try {
            receiver.sendMessage(this.get(key, replacements));
            return true;
        }
        catch (InvalidNodeException e) {
            receiver.sendMessage(this.invalidKeyError(key));
            return false;
        }
    }
}

