/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.config;

import de.kwantux.config.util.Transformation;
import de.kwantux.config.util.exceptions.InvalidNodeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.SerializationException;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;
import org.spongepowered.configurate.ConfigurationNode;

public abstract class RawConfiguration {
    protected JavaPlugin plugin;
    protected Logger logger = Bukkit.getLogger();
    protected String path;
    protected List<String> requirements = new ArrayList<String>();
    protected List<Transformation> transformations = new ArrayList<Transformation>();

    protected abstract void update();

    protected void resolveTransformations(ComparableVersion oldVersion, ComparableVersion newVersion) {
        for (Transformation transformation : this.transformations) {
            if (transformation.minVersion() != null && oldVersion.compareTo(transformation.minVersion()) < 0 || transformation.maxVersion() != null && oldVersion.compareTo(transformation.maxVersion()) > 0) continue;
            try {
                ConfigurationNode node = this.get(transformation.oldKey());
                if (node.isNull()) continue;
                if (transformation.transform() != null) {
                    node = transformation.transform().apply(node);
                }
                if (transformation.newKey() != null) {
                    this.set(transformation.newKey(), node);
                }
                if (!transformation.delete() || node.parent() == null || !node.parent().isMap()) continue;
                node.parent().removeChild(node.key());
            }
            catch (InvalidNodeException invalidNodeException) {}
        }
    }

    public abstract void reload();

    public abstract void save();

    public void require(String path) {
        if (!this.requirements.contains(path)) {
            this.requirements.add(path);
        }
    }

    public void require(String ... paths) {
        this.requirements.addAll(Arrays.stream(paths).toList());
    }

    public void require(List<String> paths) {
        this.requirements.addAll(paths);
    }

    public void unrequire(String path) {
        this.requirements.remove(path);
    }

    public boolean testRequirements() {
        boolean result = true;
        for (String req : this.requirements) {
            if (this.has(req)) continue;
            this.logger.severe("[QC] Configuration file '" + this.path + "' is missing option: " + req);
            result = false;
        }
        return result;
    }

    public boolean silentTestRequirements() {
        boolean result = true;
        for (String req : this.requirements) {
            if (this.has(req)) continue;
            result = false;
        }
        return result;
    }

    public abstract ConfigurationNode get(String var1) throws InvalidNodeException;

    public abstract void set(String var1, Object var2) throws SerializationException;

    public String getPath() {
        return this.path;
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public abstract boolean has(String var1);

    public void transformation(Transformation transformation) {
        this.transformations.add(transformation);
    }
}

