/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.config;

import de.kwantux.config.Configuration;
import de.kwantux.config.util.exceptions.ConfigAlreadyRegisteredException;
import de.kwantux.config.util.exceptions.InvalidNodeException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;

public final class ConfigurationManager {
    private static final List<Configuration> rootNodes = new ArrayList<Configuration>();

    public static void addConfiguration(Configuration configuration) throws ConfigAlreadyRegisteredException {
        for (Configuration conf : rootNodes) {
            if (!configuration.getPath().equalsIgnoreCase(conf.getPath())) continue;
            throw new ConfigAlreadyRegisteredException("There is already a config registered with the path " + conf.getPath());
        }
        rootNodes.add(configuration);
    }

    @Nullable
    public static Configuration getRootConfiguration(@NotNull String path) throws InvalidNodeException {
        for (Configuration c : rootNodes) {
            if (!c.getPath().equalsIgnoreCase(path)) continue;
            return c;
        }
        throw new InvalidNodeException("No root node found with the path " + path);
    }

    @Nullable
    public static Configuration getRootConfiguration(@NotNull JavaPlugin plugin) throws InvalidNodeException {
        return ConfigurationManager.getRootConfiguration(plugin.getName());
    }

    @Nullable
    public static Configuration getRootConfiguration(@NotNull JavaPlugin plugin, @NotNull String path) throws InvalidNodeException {
        return ConfigurationManager.getRootConfiguration(plugin.getName() + "." + path);
    }

    @Nullable
    public static ConfigurationNode getNode(@NotNull String rootPath, @NotNull String nodePath) throws InvalidNodeException {
        Configuration c = ConfigurationManager.getRootConfiguration(rootPath);
        if (c == null) {
            throw new InvalidNodeException("No root node found with given path");
        }
        return c.get(nodePath);
    }

    public static void saveAll() {
        for (Configuration c : rootNodes) {
            c.save();
        }
    }

    public static void reloadAll() {
        for (Configuration c : rootNodes) {
            c.reload();
        }
    }
}

