/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.networks.utils;

import de.kwantux.networks.Main;
import de.kwantux.networks.utils.Origin;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;

public class BlockLocation
extends Origin {
    private int x;
    private int y;
    private int z;
    private UUID world;

    public BlockLocation(int x, int y, int z, UUID world) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.world = world;
    }

    public BlockLocation(@Nonnull Location location) {
        this.x = location.getBlockX();
        this.y = location.getBlockY();
        this.z = location.getBlockZ();
        this.world = location.getWorld().getUID();
    }

    public BlockLocation(@Nonnull Block block) {
        this.x = block.getX();
        this.y = block.getY();
        this.z = block.getZ();
        this.world = block.getWorld().getUID();
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public void setWorld(UUID world) {
        this.world = world;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public UUID getWorld() {
        return this.world;
    }

    public Location getBukkitLocation() {
        return new Location(Bukkit.getWorld((UUID)this.getWorld()), (double)this.x, (double)this.y, (double)this.z);
    }

    public Block getBlock() {
        return this.getBukkitLocation().getBlock();
    }

    @Override
    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }

    @Override
    public Component displayText() {
        return ((TextComponent)Component.text((String)this.toString()).clickEvent(ClickEvent.runCommand((String)("/tpw " + this.world.toString() + " " + this.x + " " + this.y + " " + this.z)))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Main.lang.getFinal("click-to-tp")));
    }

    public boolean equals(Object otherObject) {
        if (otherObject instanceof BlockLocation) {
            BlockLocation other = (BlockLocation)otherObject;
            return other.getX() == this.getX() && other.getY() == this.getY() && other.getZ() == this.getZ() && other.getWorld().equals(this.getWorld());
        }
        return false;
    }

    public int hashCode() {
        return (this.world.toString() + "," + this.x + "," + this.y + "," + this.z).hashCode();
    }

    public double getDistance(BlockLocation second) {
        if (!second.getWorld().equals(this.getWorld())) {
            return 2.147483647E9;
        }
        return Math.sqrt(Math.pow(this.x - second.getX(), 2.0) + Math.pow(this.y - second.getY(), 2.0) + Math.pow(this.z - second.getZ(), 2.0));
    }

    public static void register() {
        Origin.register(BlockLocation.class, "block");
    }
}

