/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.networks.event;

import de.kwantux.config.util.exceptions.InvalidNodeException;
import de.kwantux.networks.Main;
import de.kwantux.networks.Network;
import de.kwantux.networks.commands.NetworksCommand;
import de.kwantux.networks.component.BasicComponent;
import de.kwantux.networks.component.BlockComponent;
import de.kwantux.networks.component.component.InputContainer;
import de.kwantux.networks.component.component.SortingContainer;
import de.kwantux.networks.component.module.Acceptor;
import de.kwantux.networks.component.module.BaseModule;
import de.kwantux.networks.config.Config;
import de.kwantux.networks.utils.BlockLocation;
import de.kwantux.networks.utils.ItemHash;
import java.util.HashSet;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class WandListener
implements Listener {
    public WandListener(Main plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) throws InvalidNodeException {
        Player p = event.getPlayer();
        BlockLocation l = null;
        if (event.getClickedBlock() != null) {
            l = new BlockLocation(event.getClickedBlock());
        }
        Action action = event.getAction();
        ItemStack wand = p.getInventory().getItemInMainHand();
        if (!wand.getType().equals((Object)Material.AIR)) {
            BaseModule container;
            if (wand.getItemMeta().getPersistentDataContainer().has(new NamespacedKey("networks", "wand"), PersistentDataType.INTEGER)) {
                BasicComponent c;
                event.setCancelled(true);
                if (!event.getHand().equals((Object)EquipmentSlot.HAND)) {
                    return;
                }
                int mode = (Integer)wand.getItemMeta().getPersistentDataContainer().get(new NamespacedKey("networks", "wand"), PersistentDataType.INTEGER);
                if (!p.isSneaking() && (action.equals((Object)Action.LEFT_CLICK_BLOCK) || action.equals((Object)Action.LEFT_CLICK_AIR)) && !p.isSneaking()) {
                    if (++mode > 2) {
                        mode = 0;
                    }
                    event.getItem().setItemMeta(Main.crf.getNetworkWand(mode).getItemMeta());
                    Main.lang.message((CommandSender)p, "wand.mode", Main.lang.getRaw("wand.mode." + mode));
                    return;
                }
                if (l == null) {
                    return;
                }
                BasicComponent component = Main.dcu.componentAt(l);
                Network network = null;
                if (component != null) {
                    network = Main.dcu.networkWithComponentAt(component.origin());
                }
                if (!p.isSneaking()) {
                    if (action.equals((Object)Action.RIGHT_CLICK_BLOCK)) {
                        if (component != null) {
                            boolean isProxy = network.getComponent(component.origin()) == null;
                            p.sendMessage(NetworksCommand.componentInfo(network, component, isProxy));
                        } else {
                            Main.lang.message((CommandSender)p, "component.nocomponent");
                        }
                    }
                    return;
                }
                if (action.equals((Object)Action.LEFT_CLICK_AIR) || action.equals((Object)Action.RIGHT_CLICK_AIR)) {
                    return;
                }
                if (component == null) {
                    Main.lang.message((CommandSender)p, "component.nocomponent");
                    return;
                }
                if (!Main.mgr.permissionUser((CommandSender)p, network)) {
                    Main.lang.message((CommandSender)p, "permission.user");
                    return;
                }
                ItemStack itemInOffHand = p.getInventory().getItemInOffHand();
                if (action.equals((Object)Action.RIGHT_CLICK_BLOCK)) {
                    Object filters;
                    if (mode == 0 && !itemInOffHand.getType().equals((Object)Material.AIR) && Main.dcu.componentAt(l) instanceof SortingContainer && (c = Main.dcu.componentAt(l)) instanceof SortingContainer) {
                        SortingContainer container2 = (SortingContainer)c;
                        container2.addFilter(ItemHash.materialHash(itemInOffHand));
                        Main.lang.message((CommandSender)p, "component.sorting.setitem", l.toString(), itemInOffHand.getType().toString());
                    }
                    if (mode == 0 && itemInOffHand.getType().equals((Object)Material.AIR) && component instanceof SortingContainer) {
                        container = (SortingContainer)component;
                        filters = new HashSet();
                        for (int num : ((SortingContainer)container).filters()) {
                            ((HashSet)filters).add(num);
                        }
                        for (ItemStack item : ((BlockComponent)((Object)container)).inventory().getContents()) {
                            Integer itemType;
                            if (item == null || ((HashSet)filters).contains(itemType = Integer.valueOf(ItemHash.materialHash(item)))) continue;
                            ((SortingContainer)container).addFilter(itemType);
                            ((HashSet)filters).add(itemType);
                        }
                        Main.lang.message((CommandSender)p, "component.sorting.autofilter", l.toString());
                    }
                    if (mode == 1 && component instanceof Acceptor) {
                        container = (Acceptor)((Object)component);
                        container.incrementAcceptorPriority();
                        Main.lang.message((CommandSender)p, "component.priority", String.valueOf(container.acceptorPriority()));
                    }
                    if (mode == 2 && !itemInOffHand.getType().equals((Object)Material.AIR) && (filters = Main.dcu.componentAt(l)) instanceof SortingContainer) {
                        container = (SortingContainer)filters;
                        int hash = ItemHash.strictHash(itemInOffHand);
                        ((SortingContainer)container).addFilter(hash);
                        Main.lang.message((CommandSender)p, "component.sorting.setitem", l.displayText(), itemInOffHand.displayName());
                    }
                    if (mode == 2 && itemInOffHand.getType().equals((Object)Material.AIR) && component instanceof SortingContainer) {
                        container = (SortingContainer)component;
                        HashSet<Integer> filters2 = new HashSet<Integer>();
                        for (int num : ((SortingContainer)container).filters()) {
                            filters2.add(num);
                        }
                        for (ItemStack item : ((BlockComponent)((Object)container)).inventory().getContents()) {
                            int hash;
                            if (item == null || filters2.contains(hash = ItemHash.strictHash(item))) continue;
                            ((SortingContainer)container).addFilter(hash);
                            filters2.add(hash);
                        }
                        Main.lang.message((CommandSender)p, "component.sorting.autofilter", l.displayText());
                    }
                }
                if (action.equals((Object)Action.LEFT_CLICK_BLOCK)) {
                    BasicComponent container322;
                    if ((mode == 0 || mode == 2) && Main.dcu.componentAt(l) instanceof SortingContainer && !itemInOffHand.getType().equals((Object)Material.AIR) && p.isSneaking() && (c = Main.dcu.componentAt(l)) instanceof SortingContainer) {
                        SortingContainer container322 = (SortingContainer)c;
                        container322.removeFilter(ItemHash.materialHash(itemInOffHand));
                        container322.removeFilter(ItemHash.strictHash(itemInOffHand));
                        Main.lang.message((CommandSender)p, "component.sorting.removeitem", l.displayText(), itemInOffHand.displayName());
                    }
                    if ((mode == 0 || mode == 2) && (container322 = Main.dcu.componentAt(l)) instanceof SortingContainer) {
                        container = (SortingContainer)container322;
                        if (itemInOffHand.getType().equals((Object)Material.AIR) && p.isSneaking()) {
                            HashSet<Integer> filters = new HashSet<Integer>();
                            for (ItemStack item : ((BlockComponent)((Object)container)).inventory().getContents()) {
                                if (item == null) continue;
                                if (mode == 2) {
                                    int hash = ItemHash.strictHash(item);
                                    filters.add(hash);
                                }
                                if (mode != 0) continue;
                                filters.add(ItemHash.materialHash(item));
                            }
                            int[] nArray = new int[filters.size()];
                            int i = 0;
                            for (Integer filter : filters) {
                                nArray[i] = filter;
                                ++i;
                            }
                            ((SortingContainer)container).setFilters(nArray);
                            Main.lang.message((CommandSender)p, "component.sorting.autofilter", l.displayText());
                        }
                    }
                    if (mode == 1 && component instanceof Acceptor) {
                        container = (Acceptor)((Object)component);
                        container.decrementAcceptorPriority();
                        Main.lang.message((CommandSender)p, "component.priority", String.valueOf(container.acceptorPriority()));
                    }
                }
            }
            if (p.getInventory().getItemInMainHand().getItemMeta().getPersistentDataContainer().has(new NamespacedKey("networks", "upgrade.range"), PersistentDataType.INTEGER) && action.equals((Object)Action.RIGHT_CLICK_BLOCK)) {
                Runnable rangeUp;
                int tier;
                event.setCancelled(true);
                BasicComponent component = Main.dcu.componentAt(l);
                Network network = Main.dcu.networkWithComponentAt(l);
                if (component == null) {
                    Main.lang.message((CommandSender)p, "component.nocomponent");
                    return;
                }
                if (Config.rangePerNetwork) {
                    tier = network.rangeTier();
                    rangeUp = () -> network.range(Config.ranges[tier + 1]);
                } else if (component instanceof InputContainer) {
                    container = (InputContainer)component;
                    tier = ((InputContainer)container).range();
                    rangeUp = ((InputContainer)container)::rangeUp;
                } else {
                    Main.lang.message((CommandSender)p, "rangeupgrade.passivecomponent");
                    return;
                }
                int upgradeTier = (Integer)p.getInventory().getItemInMainHand().getItemMeta().getPersistentDataContainer().get(new NamespacedKey("networks", "upgrade.range"), PersistentDataType.INTEGER) - 1;
                if (upgradeTier == tier) {
                    ItemStack itemStack = p.getInventory().getItemInMainHand();
                    itemStack.setAmount(itemStack.getAmount() - 1);
                    rangeUp.run();
                    if (Config.rangePerNetwork) {
                        Main.lang.message((CommandSender)p, "rangeupgrade.success.network", String.valueOf(tier + 1), network.name());
                    } else {
                        Main.lang.message((CommandSender)p, "rangeupgrade.success", String.valueOf(tier + 1), component.origin().toString());
                    }
                }
                if (tier == Config.ranges.length) {
                    Main.lang.message((CommandSender)p, "rangeupgrade.last");
                    return;
                }
                if (tier > Config.ranges.length || tier < 0) {
                    Main.lang.message((CommandSender)p, "rangeupgrade.invalid");
                    return;
                }
                if (upgradeTier < tier) {
                    Main.lang.message((CommandSender)p, "rangeupgrade.alreadyupgraded", String.valueOf(tier));
                }
                if (upgradeTier > tier) {
                    Main.lang.message((CommandSender)p, "rangeupgrade.unlockfirst", String.valueOf(tier + 1));
                }
            }
        }
    }
}

