/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.networks.event;

import de.kwantux.networks.Main;
import de.kwantux.networks.Network;
import de.kwantux.networks.component.BlockComponent;
import de.kwantux.networks.config.Config;
import de.kwantux.networks.utils.BlockLocation;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BlockBreakListener
implements Listener {
    public BlockBreakListener(Main main) {
        main.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)main);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void blockBreak(BlockBreakEvent event) {
        for (Network network : Main.mgr.getNetworks()) {
            for (BlockComponent component2 : network.components().stream().filter(component -> component instanceof BlockComponent).map(component -> (BlockComponent)component).toList()) {
                if (!component2.pos().equals(new BlockLocation(event.getBlock()))) continue;
                Main.dcu.disconnectChests(component2.pos());
                if (Main.mgr.permissionUser((CommandSender)event.getPlayer(), network)) {
                    ItemStack item = component2.item();
                    Bukkit.getServer().getWorld(component2.pos().getWorld()).dropItem(component2.pos().getBukkitLocation(), item);
                    BlockLocation location = new BlockLocation(event.getBlock());
                    Main.mgr.removeComponent(location);
                    Main.lang.message((CommandSender)event.getPlayer(), "component.remove", location.toString());
                    continue;
                }
                Main.lang.message((CommandSender)event.getPlayer(), "permission.user");
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(EntityExplodeEvent event) {
        ArrayList<Block> removeLater = new ArrayList<Block>();
        for (Block block : event.blockList()) {
            if (Main.mgr.getComponent(new BlockLocation(block)) == null) continue;
            removeLater.add(block);
        }
        for (Block block : removeLater) {
            if (!Config.blastProofComponents) {
                BlockComponent component = (BlockComponent)Main.mgr.getComponent(new BlockLocation(block));
                assert (component != null);
                ItemStack item = component.item();
                Bukkit.getServer().getWorld(component.pos().getWorld()).dropItem(component.pos().getBukkitLocation(), item);
                event.blockList().remove(block);
                block.setType(Material.AIR);
                Network network = Main.mgr.getNetworkWithComponent(new BlockLocation(block));
                network.removeComponent(new BlockLocation(block));
                ArrayList users = (ArrayList)network.users();
                users.add(network.owner());
                for (UUID uid : users) {
                    if (Bukkit.getPlayer((UUID)uid) == null) continue;
                    Main.lang.message((CommandSender)Bukkit.getPlayer((UUID)uid), "component.exploded", network.name(), new BlockLocation(block).toString());
                }
            }
            event.blockList().remove(block);
        }
    }
}

