/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.networks.config;

import de.kwantux.config.Configuration;
import de.kwantux.config.lang.LanguageController;
import de.kwantux.config.util.exceptions.ConfigAlreadyRegisteredException;
import de.kwantux.config.util.exceptions.InvalidNodeException;
import de.kwantux.networks.Main;
import de.kwantux.networks.compat.ConfigurationTransformers;
import de.kwantux.networks.component.util.ComponentType;
import de.kwantux.networks.config.Config;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.spongepowered.configurate.serialize.SerializationException;

public class CraftingManager {
    private final Main plugin;
    private final Configuration config;
    private final Logger logger;
    private final LanguageController lang;
    private final Config pluginconfig;
    private final Material rangeUpgradeMaterial;
    private final Material componentUpgradeMaterial;
    public static List<NamespacedKey> recipes = new ArrayList<NamespacedKey>();
    private final char[] keys = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i'};

    public void save() {
        this.config.save();
    }

    public ItemStack getNetworkWand(int mode) {
        ItemStack wand = new ItemStack(Material.BLAZE_ROD);
        ItemMeta meta = wand.getItemMeta();
        try {
            meta.displayName(this.lang.getItemName("wand" + mode));
            meta.lore(this.lang.getItemLore("wand" + mode));
        }
        catch (InvalidNodeException e) {
            throw new RuntimeException(e);
        }
        PersistentDataContainer data = meta.getPersistentDataContainer();
        data.set(new NamespacedKey((Plugin)this.plugin, "wand"), PersistentDataType.INTEGER, (Object)mode);
        wand.setItemMeta(meta);
        return wand;
    }

    public ItemStack getRangeUpgrade(int tier) throws InvalidNodeException {
        ItemStack upgrade = new ItemStack(this.rangeUpgradeMaterial);
        ItemMeta meta = upgrade.getItemMeta();
        meta.displayName(this.lang.getItemName("upgrade.range." + (tier - 1)));
        meta.lore(this.lang.getItemLore("upgrade.range"));
        PersistentDataContainer data = meta.getPersistentDataContainer();
        data.set(new NamespacedKey((Plugin)this.plugin, "upgrade.range"), PersistentDataType.INTEGER, (Object)tier);
        upgrade.setItemMeta(meta);
        return upgrade;
    }

    public CraftingManager(Main main) {
        this.plugin = main;
        try {
            this.config = Configuration.create((JavaPlugin)main, "recipes", "recipes.conf");
            ConfigurationTransformers.recipesTransformers(this.config);
            this.config.update();
        }
        catch (ConfigAlreadyRegisteredException e) {
            throw new RuntimeException(e);
        }
        this.lang = main.getLanguage();
        this.logger = main.getLogger();
        this.pluginconfig = main.getConfiguration();
        this.componentUpgradeMaterial = this.pluginconfig.getComponentUpgradeMaterial();
        this.rangeUpgradeMaterial = this.pluginconfig.getRangeUpgradeMaterial();
        this.registerRecipes();
        main.getLogger().info("Initialiased Crafting Recipes");
    }

    private void registerRecipes() {
        this.registerItem("wand", this.getNetworkWand(2));
        for (ComponentType type : ComponentType.types.values()) {
            this.registerComponent(type);
        }
        this.registerRangeUpgrades();
    }

    private void registerItem(String path, ItemStack result) {
        try {
            int i;
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, path.replace(".", "_"));
            ShapedRecipe recipe = new ShapedRecipe(key, result);
            List<String> ingredients = this.config.getList(path, String.class);
            String[] shape = new String[9];
            for (i = 0; i < 9; ++i) {
                shape[i] = ingredients.get(i).equalsIgnoreCase("AIR") || ingredients.get(i).equalsIgnoreCase("EMPTY") ? " " : String.valueOf(this.keys[i]);
            }
            recipe.shape(new String[]{shape[0] + shape[1] + shape[2], shape[3] + shape[4] + shape[5], shape[6] + shape[7] + shape[8]});
            for (i = 0; i < 9; ++i) {
                if (shape[i].equalsIgnoreCase(" ")) continue;
                try {
                    recipe.setIngredient(this.keys[i], Material.valueOf((String)ingredients.get(i)));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.logger.severe(ingredients.get(i) + " is not a valid material, it will replaced with AIR. Recipe " + path + " may be broken.");
                    recipe.setIngredient(this.keys[i], Material.AIR);
                }
            }
            Bukkit.addRecipe((Recipe)recipe);
            recipes.add(key);
        }
        catch (InvalidNodeException | SerializationException e) {
            this.logger.severe("Config file recipes.conf seems to have an invalid format or is missing some data, the cfg file was deleted, server will be restarted...");
            this.logger.severe("==============================================================================================================================================");
            File file = new File(this.plugin.getDataFolder(), "recipes.conf");
            file.delete();
            e.printStackTrace();
            Bukkit.shutdown();
        }
    }

    private void registerComponent(ComponentType type) {
        String path = "component." + type.tag;
        String matkey = this.componentUpgradeMaterial.name();
        ItemStack stack = type.item();
        try {
            int i;
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, path.replace(".", "_"));
            ShapedRecipe recipe = new ShapedRecipe(key, stack);
            List<String> ingredients = this.config.getList(path, String.class);
            assert (ingredients != null);
            for (String s : ingredients) {
                if (!s.equalsIgnoreCase("BASE_ITEM")) continue;
                s = matkey;
            }
            String[] shape = new String[9];
            for (i = 0; i < 9; ++i) {
                if (ingredients.get(i).equalsIgnoreCase("BASE_ITEM")) {
                    ingredients.set(i, matkey);
                }
                shape[i] = ingredients.get(i).equalsIgnoreCase("AIR") || ingredients.get(i).equalsIgnoreCase("EMPTY") ? " " : String.valueOf(this.keys[i]);
            }
            recipe.shape(new String[]{shape[0] + shape[1] + shape[2], shape[3] + shape[4] + shape[5], shape[6] + shape[7] + shape[8]});
            for (i = 0; i < 9; ++i) {
                if (shape[i].equalsIgnoreCase(" ")) continue;
                try {
                    recipe.setIngredient(this.keys[i], Material.valueOf((String)ingredients.get(i)));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.logger.severe(ingredients.get(i) + " is not a valid material, it will replaced with AIR. Recipe " + path + " may be broken.");
                    recipe.setIngredient(this.keys[i], Material.AIR);
                }
            }
            Bukkit.addRecipe((Recipe)recipe);
            recipes.add(key);
        }
        catch (InvalidNodeException | SerializationException e) {
            this.logger.severe("Config file recipes.conf seems to have an invalid format or is missing some data, the cfg file was deleted, server will be restarted...");
            this.logger.severe("==============================================================================================================================================");
            File file = new File(this.plugin.getDataFolder(), "recipes.conf");
            file.delete();
            e.printStackTrace();
            Bukkit.shutdown();
        }
    }

    private void registerRangeUpgrades() {
        try {
            for (int i = 1; i <= this.config.get("upgrade.range").childrenList().size(); ++i) {
                int j;
                String path = "upgrade.range." + (i - 1);
                NamespacedKey key = new NamespacedKey((Plugin)this.plugin, path.replace(".", "_"));
                ShapedRecipe recipe = new ShapedRecipe(key, this.getRangeUpgrade(i));
                List<String> ingredients = this.config.getList(path, String.class);
                String[] shape = new String[9];
                for (j = 0; j < 9; ++j) {
                    shape[j] = ingredients.get(j).equalsIgnoreCase("AIR") || ingredients.get(j).equalsIgnoreCase("EMPTY") ? " " : String.valueOf(this.keys[j]);
                }
                recipe.shape(new String[]{shape[0] + shape[1] + shape[2], shape[3] + shape[4] + shape[5], shape[6] + shape[7] + shape[8]});
                for (j = 0; j < 9; ++j) {
                    if (shape[j].equalsIgnoreCase(" ")) continue;
                    try {
                        recipe.setIngredient(this.keys[j], Material.valueOf((String)ingredients.get(j)));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        this.logger.severe(ingredients.get(j) + " is not a valid material, it will replaced with AIR. Recipe " + path + " may be broken.");
                        recipe.setIngredient(this.keys[j], Material.AIR);
                    }
                }
                Bukkit.addRecipe((Recipe)recipe);
                recipes.add(key);
            }
        }
        catch (InvalidNodeException | SerializationException e) {
            this.logger.severe("Config file recipes.conf seems to have an invalid format or is missing some data, please delete this file, restart the server and try again!");
            throw new RuntimeException(e);
        }
    }
}

