/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.networks.component.component;

import de.kwantux.networks.component.BlockComponent;
import de.kwantux.networks.component.module.Acceptor;
import de.kwantux.networks.component.module.Supplier;
import de.kwantux.networks.component.util.ComponentType;
import de.kwantux.networks.utils.BlockLocation;
import de.kwantux.networks.utils.ItemHash;
import de.kwantux.networks.utils.NamespaceUtils;
import de.kwantux.networks.utils.Origin;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.kyori.adventure.text.Component;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.Nullable;

public class SortingContainer
extends BlockComponent
implements Acceptor,
Supplier {
    public static ComponentType type;
    private int[] filters;
    private int acceptorPriority;
    private int supplierPriority;
    private static Map<String, Object> defaultProperties;

    @Override
    public ComponentType type() {
        return type;
    }

    @Nullable
    public static SortingContainer create(Origin origin, PersistentDataContainer container) {
        if (origin instanceof BlockLocation) {
            int[] filters;
            BlockLocation pos = (BlockLocation)origin;
            if (container == null) {
                return new SortingContainer(pos, new int[0], 10, 0);
            }
            try {
                filters = Objects.requireNonNull((int[])container.get(NamespaceUtils.FILTERS.key(), PersistentDataType.INTEGER_ARRAY));
            }
            catch (Exception e) {
                filters = SortingContainer.convertLegacyFilters(Objects.requireNonNullElse(((String)Objects.requireNonNullElse((String)container.get(NamespaceUtils.FILTERS.key(), PersistentDataType.STRING), null)).split(","), new String[0]));
            }
            filters = Arrays.stream(filters).distinct().filter(i -> i != 0).toArray();
            return new SortingContainer(pos, filters, Objects.requireNonNullElse((Integer)container.get(NamespaceUtils.ACCEPTOR_PRIORITY.key(), PersistentDataType.INTEGER), 10), Objects.requireNonNullElse((Integer)container.get(NamespaceUtils.SUPPLIER_PRIORITY.key(), PersistentDataType.INTEGER), 0));
        }
        return null;
    }

    public SortingContainer(BlockLocation pos, int[] filters, int acceptorPriority) {
        super(pos);
        this.filters = filters;
        this.acceptorPriority = acceptorPriority;
        this.supplierPriority = 0;
    }

    public SortingContainer(BlockLocation pos, int[] filters, int acceptorPriority, int supplierPriority) {
        super(pos);
        this.filters = filters;
        this.acceptorPriority = acceptorPriority;
        this.supplierPriority = supplierPriority;
    }

    public static ComponentType register() {
        type = ComponentType.register(SortingContainer.class, "sorting", (Component)Component.text((String)"Sorting Container"), false, true, true, false, true, SortingContainer::create, defaultProperties);
        return type;
    }

    @Override
    public boolean isMissingData() {
        if (this.filters == null) {
            this.filters = new int[0];
        }
        return this.pos == null;
    }

    @Override
    public boolean accept(@Nonnull ItemStack stack) {
        int matId = ItemHash.materialHash(stack);
        int strictHash = ItemHash.strictHash(stack);
        for (int filter : this.filters) {
            if (matId != filter && strictHash != filter) continue;
            return true;
        }
        return false;
    }

    @Override
    public int acceptorPriority() {
        return this.acceptorPriority;
    }

    @Override
    public void incrementAcceptorPriority() {
        ++this.acceptorPriority;
    }

    @Override
    public void decrementAcceptorPriority() {
        --this.acceptorPriority;
    }

    @Override
    public int supplierPriority() {
        return this.supplierPriority;
    }

    public int[] filters() {
        return this.filters;
    }

    @Override
    public Map<String, Object> properties() {
        return new HashMap<String, Object>(){
            {
                this.put(NamespaceUtils.ACCEPTOR_PRIORITY.name, SortingContainer.this.acceptorPriority);
                this.put(NamespaceUtils.SUPPLIER_PRIORITY.name, SortingContainer.this.supplierPriority);
                this.put(NamespaceUtils.FILTERS.name, SortingContainer.this.filters);
            }
        };
    }

    public void addFilter(int filter) {
        this.filters = Arrays.copyOf(this.filters, this.filters.length + 1);
        this.filters[this.filters.length - 1] = filter;
    }

    public void setFilters(int[] filters) {
        this.filters = filters;
    }

    public void removeFilter(int filter) {
        this.filters = ArrayUtils.removeElement((int[])this.filters, (int)filter);
    }

    public static int[] convertLegacyFilters(String[] filters) {
        int[] newFilters = new int[filters.length];
        for (int i = 0; i < filters.length; ++i) {
            newFilters[i] = Objects.requireNonNullElse(Material.getMaterial((String)filters[i]), Material.AIR).ordinal();
        }
        return newFilters;
    }

    static {
        defaultProperties = new HashMap<String, Object>();
        defaultProperties.put(NamespaceUtils.FILTERS.name, new int[0]);
        defaultProperties.put(NamespaceUtils.ACCEPTOR_PRIORITY.name, 10);
        defaultProperties.put(NamespaceUtils.SUPPLIER_PRIORITY.name, 0);
    }
}

