/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.networks.component.component;

import de.kwantux.networks.component.BlockComponent;
import de.kwantux.networks.component.module.Acceptor;
import de.kwantux.networks.component.module.Supplier;
import de.kwantux.networks.component.util.ComponentType;
import de.kwantux.networks.utils.BlockLocation;
import de.kwantux.networks.utils.NamespaceUtils;
import de.kwantux.networks.utils.Origin;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.kyori.adventure.text.Component;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.Nullable;

public class MiscContainer
extends BlockComponent
implements Acceptor,
Supplier {
    public static ComponentType type;
    private int acceptorPriority = -20;
    private int supplierPriority = 5;
    private static Map<String, Object> defaultProperties;

    @Override
    public ComponentType type() {
        return type;
    }

    @Nullable
    public static MiscContainer create(Origin origin, PersistentDataContainer container) {
        if (origin instanceof BlockLocation) {
            BlockLocation pos = (BlockLocation)origin;
            if (container == null) {
                return new MiscContainer(pos);
            }
            return new MiscContainer(pos, Objects.requireNonNullElse((Integer)container.get(NamespaceUtils.ACCEPTOR_PRIORITY.key(), PersistentDataType.INTEGER), -20), Objects.requireNonNullElse((Integer)container.get(NamespaceUtils.SUPPLIER_PRIORITY.key(), PersistentDataType.INTEGER), 5));
        }
        return null;
    }

    public MiscContainer(BlockLocation pos, int acceptorPriority, int supplierPriority) {
        super(pos);
        this.acceptorPriority = acceptorPriority;
        this.supplierPriority = supplierPriority;
    }

    public MiscContainer(BlockLocation pos, int acceptorPriority) {
        super(pos);
        this.acceptorPriority = acceptorPriority;
    }

    public MiscContainer(BlockLocation pos) {
        super(pos);
    }

    public static ComponentType register() {
        type = ComponentType.register(MiscContainer.class, "misc", (Component)Component.text((String)"Miscellaneous Container"), false, true, true, false, true, MiscContainer::create, defaultProperties);
        return type;
    }

    @Override
    public boolean accept(@Nonnull ItemStack stack) {
        return true;
    }

    @Override
    public int acceptorPriority() {
        return this.acceptorPriority;
    }

    @Override
    public void incrementAcceptorPriority() {
        ++this.acceptorPriority;
    }

    @Override
    public void decrementAcceptorPriority() {
        --this.acceptorPriority;
    }

    @Override
    public int supplierPriority() {
        return this.supplierPriority;
    }

    @Override
    public Map<String, Object> properties() {
        return new HashMap<String, Object>(){
            {
                this.put(NamespaceUtils.ACCEPTOR_PRIORITY.name, MiscContainer.this.acceptorPriority);
                this.put(NamespaceUtils.SUPPLIER_PRIORITY.name, MiscContainer.this.supplierPriority);
            }
        };
    }

    static {
        defaultProperties = new HashMap<String, Object>();
        defaultProperties.put(NamespaceUtils.ACCEPTOR_PRIORITY.name, -20);
        defaultProperties.put(NamespaceUtils.SUPPLIER_PRIORITY.name, 5);
    }
}

