/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.networks.compat;

import de.kwantux.networks.Main;
import de.kwantux.networks.Network;
import de.kwantux.networks.component.BlockComponent;
import de.kwantux.networks.component.component.InputContainer;
import de.kwantux.networks.component.component.MiscContainer;
import de.kwantux.networks.component.component.SortingContainer;
import de.kwantux.networks.storage.NetworkProperties;
import de.kwantux.networks.storage.SerializableNetwork;
import de.kwantux.networks.utils.BlockLocation;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.jetbrains.annotations.Nullable;

public record LegacyNetwork(UUID owner, UUID[] users, int maxRange, LegacyInputContainer[] input_containers, LegacySortingContainer[] sorting_containers, LegacyMiscContainer[] misc_containers) {
    static Map<String, UUID> uidMap = new HashMap<String, UUID>();

    public Network convert(String id) {
        Main.logger.info("Converting legacy network '" + id + "'");
        NetworkProperties properties = Main.cfg.defaultProperties();
        properties.baseRange(this.maxRange);
        ArrayList<BlockComponent> components = new ArrayList<BlockComponent>();
        Arrays.stream(this.input_containers).toList().forEach(input_container -> components.add(input_container.convert()));
        Arrays.stream(this.sorting_containers).toList().forEach(sorting_container -> components.add(sorting_container.convert()));
        Arrays.stream(this.misc_containers).toList().forEach(misc_container -> components.add(misc_container.convert()));
        components.removeIf(Objects::isNull);
        return new Network(id, new SerializableNetwork(((Main)Main.getPlugin(Main.class)).getPluginMeta().getVersion(), this.owner, this.users, properties, components.toArray(new BlockComponent[0])));
    }

    static {
        try {
            for (Path path : Files.list(Bukkit.getWorldContainer().toPath()).toList()) {
                Path file;
                if (!Files.isDirectory(path, new LinkOption[0]) || !Files.exists(file = path.resolve("uid.dat"), new LinkOption[0])) continue;
                uidMap.put(path.getFileName().toString(), UUID.nameUUIDFromBytes(Files.readAllBytes(file)));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    record LegacyInputContainer(LegacyLocation legacyLocation) {
        @Nullable
        public InputContainer convert() {
            if (this.legacyLocation == null) {
                return null;
            }
            BlockLocation pos2 = this.legacyLocation.convert();
            if (pos2 == null) {
                return null;
            }
            return new InputContainer(pos2);
        }
    }

    record LegacySortingContainer(LegacyLocation legacyLocation, String[] items, int priority) {
        @Nullable
        public SortingContainer convert() {
            if (this.legacyLocation == null) {
                return null;
            }
            BlockLocation pos = this.legacyLocation.convert();
            if (pos == null) {
                return null;
            }
            int[] filters = new int[this.items.length];
            for (int i = 0; i < this.items.length; ++i) {
                filters[i] = Objects.requireNonNullElse(Material.getMaterial((String)this.items[i]), Material.AIR).ordinal();
            }
            return new SortingContainer(pos, SortingContainer.convertLegacyFilters(this.items), this.priority);
        }
    }

    record LegacyMiscContainer(LegacyLocation legacyLocation, int priority) {
        @Nullable
        public MiscContainer convert() {
            if (this.legacyLocation == null) {
                return null;
            }
            BlockLocation pos = this.legacyLocation.convert();
            if (pos == null) {
                return null;
            }
            return new MiscContainer(pos, this.priority);
        }
    }

    record LegacyLocation(int x, int y, int z, String dim) {
        @Nullable
        public BlockLocation convert() {
            try {
                return new BlockLocation(this.x, this.y, this.z, Objects.requireNonNull(uidMap.get(this.dim)));
            }
            catch (NullPointerException _e) {
                Main.logger.severe("Unable to upgrade corrupted component at [" + this.x + " " + this.y + " " + this.z + " " + this.dim + "]\nIt will be permanently removed from the network.");
                return null;
            }
        }
    }
}

