/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.networks.commands;

import de.kwantux.networks.Main;
import de.kwantux.networks.commands.CommandHandler;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.bukkit.parser.location.LocationParser;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.parser.standard.UUIDParser;
import org.incendo.cloud.setting.ManagerSetting;
import org.incendo.cloud.setting.Setting;

public class TeleportCommand
extends CommandHandler {
    public TeleportCommand(Main plugin, CommandManager<CommandSender> commandManager) {
        super(plugin, commandManager);
    }

    @Override
    public void register() {
        this.cmd.settings().set((Setting)ManagerSetting.ALLOW_UNSAFE_REGISTRATION, true);
        this.cmd.command(this.cmd.commandBuilder("teleporttoworld", new String[]{"tpw"}).required("world", UUIDParser.uuidParser()).required("location", LocationParser.locationParser()).senderType(Player.class).handler(this::teleport).permission("networks.teleport"));
    }

    private void teleport(CommandContext<Player> context) {
        World world = Bukkit.getWorld((UUID)((UUID)context.get("world")));
        Location location = (Location)context.get("location");
        if (world == null) {
            Main.lang.message((CommandSender)context.sender(), "teleport.world-invalid", context.get("world").toString());
            return;
        }
        ((Player)context.sender()).teleport(new Location(world, location.getX(), location.getY(), location.getZ()));
        Main.lang.message((CommandSender)context.sender(), "teleport.success", world.getName(), "" + location.getX(), "" + location.getY(), "" + location.getZ());
    }
}

