/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.networks.commands;

import de.kwantux.config.util.exceptions.InvalidNodeException;
import de.kwantux.networks.Main;
import de.kwantux.networks.Network;
import de.kwantux.networks.commands.CommandHandler;
import de.kwantux.networks.commands.ComponentTypeParser;
import de.kwantux.networks.commands.NetworkParser;
import de.kwantux.networks.commands.NetworksCommand;
import de.kwantux.networks.commands.TeleportCommand;
import de.kwantux.networks.component.util.ComponentType;
import io.leangen.geantyref.TypeToken;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.caption.Caption;
import org.incendo.cloud.caption.CaptionProvider;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.paper.LegacyPaperCommandManager;
import org.incendo.cloud.parser.ParserRegistry;

public final class NetworksCommandManager {
    private LegacyPaperCommandManager<CommandSender> commandManager;
    private ParserRegistry<CommandSender> parsers;

    public NetworksCommandManager(Main plugin) {
        this.commandManager = LegacyPaperCommandManager.createNative((Plugin)plugin, (ExecutionCoordinator)ExecutionCoordinator.simpleCoordinator());
        this.parsers = this.commandManager.parserRegistry();
        this.parsers.registerParserSupplier(TypeToken.get(Network.class), op -> new NetworkParser());
        this.parsers.registerParserSupplier(TypeToken.get(ComponentType.class), op -> new ComponentTypeParser(false));
        this.commandManager.captionRegistry().registerProvider(CaptionProvider.forCaption((Caption)Caption.of((String)"argument.parse.failure.network"), sender -> {
            try {
                return Main.lang.getRaw("invalid.network");
            }
            catch (InvalidNodeException e) {
                return "No such network: <input>";
            }
        }));
        this.commandManager.captionRegistry().registerProvider(CaptionProvider.forCaption((Caption)Caption.of((String)"argument.parse.failure.componenttype"), sender -> {
            try {
                return Main.lang.getRaw("invalid.componenttype");
            }
            catch (InvalidNodeException e) {
                return "No such component type: <input>";
            }
        }));
        List.of(new NetworksCommand(plugin, (CommandManager<CommandSender>)this.commandManager), new TeleportCommand(plugin, (CommandManager<CommandSender>)this.commandManager)).forEach(CommandHandler::register);
    }
}

