/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.networks;

import de.kwantux.networks.Main;
import de.kwantux.networks.component.BasicComponent;
import de.kwantux.networks.component.component.SortingContainer;
import de.kwantux.networks.component.module.Acceptor;
import de.kwantux.networks.component.module.Supplier;
import de.kwantux.networks.config.Config;
import de.kwantux.networks.storage.NetworkProperties;
import de.kwantux.networks.storage.SerializableNetwork;
import de.kwantux.networks.utils.ItemHash;
import de.kwantux.networks.utils.Origin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextDecoration;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class Network {
    private String id;
    private UUID owner;
    private List<UUID> users = new ArrayList<UUID>();
    private List<BasicComponent> components = new ArrayList<BasicComponent>();
    private int range;
    private int maxUsers;
    private int maxComponents;
    private static final Material[] materials = new Material[Material.values().length];

    public Network(String name, UUID owner) {
        this.id = name;
        this.owner = owner;
        this.properties(Main.cfg.defaultProperties());
    }

    public Network(String id, SerializableNetwork network) {
        this.id = id;
        this.owner = network.owner();
        this.properties(network.properties());
        this.users = new ArrayList<UUID>(Arrays.stream(network.users()).toList());
        this.components = new ArrayList<BasicComponent>(Arrays.asList(network.components()));
        this.components.removeAll(Collections.singleton(null));
        this.legacyConversion(new ComparableVersion(network.version()));
    }

    public static boolean validName(String name) {
        return name.matches("^[a-zA-Z0-9_-]*$") && name.length() <= 20 && name.length() >= 3;
    }

    public String name() {
        return this.id;
    }

    public void name(String newName) {
        this.id = newName;
    }

    public UUID owner() {
        return this.owner;
    }

    public void owner(UUID owner) {
        this.owner = owner;
    }

    public List<UUID> users() {
        return this.users;
    }

    public void addUser(UUID player) {
        this.users.add(player);
    }

    public void removeUser(UUID player) {
        this.users.remove(player);
    }

    public List<? extends BasicComponent> components() {
        return this.components;
    }

    public List<? extends Supplier> suppliers() {
        ArrayList<Supplier> suppliers = new ArrayList<Supplier>();
        for (BasicComponent component : this.components) {
            if (!(component instanceof Supplier)) continue;
            suppliers.add((Supplier)((Object)component));
        }
        return suppliers.stream().sorted(Comparator.comparingInt(Supplier::supplierPriority).reversed()).toList();
    }

    public List<? extends Acceptor> acceptors() {
        ArrayList<Acceptor> acceptors = new ArrayList<Acceptor>();
        for (BasicComponent component : this.components) {
            if (!(component instanceof Acceptor)) continue;
            acceptors.add((Acceptor)((Object)component));
        }
        return acceptors.stream().sorted(Comparator.comparingInt(Acceptor::acceptorPriority).reversed()).toList();
    }

    public BasicComponent getComponent(Origin origin) {
        for (BasicComponent component : this.components) {
            if (!component.origin().equals(origin)) continue;
            return component;
        }
        return null;
    }

    public void addComponent(BasicComponent component) {
        this.components.add(component);
    }

    public void removeComponent(BasicComponent component) {
        this.components.remove(component);
    }

    public void removeComponent(Origin origin) {
        this.components.remove(this.getComponent(origin));
    }

    public NetworkProperties properties() {
        return new NetworkProperties(this.range, this.maxComponents, this.maxUsers);
    }

    public void properties(@NotNull NetworkProperties properties) {
        this.range = properties.baseRange();
        this.maxUsers = properties.maxUsers();
        this.maxComponents = properties.maxComponents();
    }

    public Component displayText() {
        Component userlist = ((TextComponent)Component.text((String)Objects.requireNonNullElse(Bukkit.getOfflinePlayer((UUID)this.owner).getName(), this.owner.toString())).decorate(TextDecoration.UNDERLINED)).decorate(TextDecoration.BOLD);
        userlist = userlist.append(((TextComponent)Component.newline().decoration(TextDecoration.BOLD, false)).decoration(TextDecoration.UNDERLINED, false));
        for (UUID user : this.users) {
            userlist = userlist.append(((TextComponent)Component.text((String)Objects.requireNonNullElse(Bukkit.getOfflinePlayer((UUID)user).getName(), user.toString())).decorate(TextDecoration.UNDERLINED)).decorate(TextDecoration.BOLD));
            userlist = userlist.append((Component)Component.newline());
        }
        return Component.text((String)this.name()).hoverEvent((HoverEventSource)HoverEvent.showText((Component)userlist));
    }

    public ArrayList<ItemStack> items() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Supplier supplier : this.suppliers()) {
            stacks.addAll(supplier.supply());
        }
        return stacks;
    }

    public HashMap<Material, Integer> materials() {
        HashMap<Material, Integer> materials = new HashMap<Material, Integer>();
        for (BasicComponent component : this.components) {
            Inventory inventory = component.inventory();
            if (inventory == null) continue;
            for (ItemStack stack : inventory.getContents()) {
                if (stack == null) continue;
                int existing = Objects.requireNonNullElse(materials.get(stack.getType()), 0);
                materials.put(stack.getType(), existing + stack.getAmount());
            }
        }
        return materials;
    }

    public boolean equals(Object o) {
        if (o instanceof Network) {
            Network network = (Network)o;
            return Objects.equals(network.id, this.id);
        }
        return false;
    }

    public int range() {
        return this.range;
    }

    public int rangeTier() {
        for (int i = 0; i < Config.ranges.length; ++i) {
            if (this.range > Config.ranges[i]) continue;
            return i;
        }
        return Config.ranges.length - 1;
    }

    public void range(int range) {
        this.range = range;
    }

    private void legacyConversion(ComparableVersion version) {
        if (version.compareTo(new ComparableVersion("3.1.2")) < 0) {
            Main.logger.info("Converting pre-3.1.2 filters in network " + this.name());
            for (BasicComponent component : this.components) {
                if (!(component instanceof SortingContainer)) continue;
                SortingContainer sorting = (SortingContainer)component;
                for (int filter : sorting.filters()) {
                    if (filter <= 0 || filter >= Material.values().length) continue;
                    if (materials[filter] == null) {
                        Material[] materialArray = Material.values();
                        int n = materialArray.length;
                        for (int i = 0; i < n; ++i) {
                            Material mat;
                            Network.materials[mat.ordinal()] = mat = materialArray[i];
                        }
                    }
                    sorting.removeFilter(filter);
                    sorting.addFilter(ItemHash.materialHash(materials[filter]));
                }
            }
        }
    }
}

