/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.networks.utils;

import de.kwantux.networks.component.util.FilterTranslator;
import javax.annotation.Nonnull;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ItemHash {
    public static final int BLANK_META_HASH;

    public static int strictHash(@Nonnull ItemStack stack) {
        int hash;
        if (stack.isEmpty()) {
            return 0;
        }
        int matHash = ItemHash.materialHash(stack.getType());
        int metaHash = ItemHash.metaHash(stack);
        int n = hash = metaHash == BLANK_META_HASH ? matHash : matHash + metaHash;
        if (!FilterTranslator.hasTranslation(hash)) {
            FilterTranslator.updateTranslation(hash, stack.displayName().hoverEvent((HoverEventSource)HoverEvent.showItem((HoverEvent.ShowItem)HoverEvent.ShowItem.showItem((Key)Key.key((String)stack.getType().name().toLowerCase()), (int)1))));
        }
        return hash;
    }

    public static int materialHash(@Nonnull Material material) {
        return material.getKey().hashCode();
    }

    public static int materialHash(@Nonnull ItemStack stack) {
        int hash = ItemHash.materialHash(stack.getType());
        if (stack.isEmpty()) {
            return 0;
        }
        if (!FilterTranslator.hasTranslation(hash)) {
            FilterTranslator.updateTranslation(hash, stack.displayName().hoverEvent((HoverEventSource)HoverEvent.showItem((HoverEvent.ShowItem)HoverEvent.ShowItem.showItem((Key)Key.key((String)stack.getType().name().toLowerCase()), (int)1))));
        }
        return hash;
    }

    private static int metaHash(@Nonnull ItemStack stack) {
        return stack.getItemMeta().getAsString().hashCode();
    }

    static {
        ItemStack blank = new ItemStack(Material.STONE);
        BLANK_META_HASH = ItemHash.metaHash(blank);
    }
}

