/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.networks.utils;

import de.kwantux.networks.Manager;
import de.kwantux.networks.Network;
import de.kwantux.networks.component.BasicComponent;
import de.kwantux.networks.utils.BlockLocation;
import de.kwantux.networks.utils.Origin;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Chest;

public class DoubleChestUtils {
    private final Manager net;

    public DoubleChestUtils(Manager net) {
        this.net = net;
    }

    public BasicComponent componentAt(Origin origin) {
        BlockLocation pos;
        BasicComponent component = this.net.getComponent(origin);
        if (component == null && origin instanceof BlockLocation && (pos = (BlockLocation)origin).getBlock().getType().equals((Object)Material.CHEST)) {
            Chest chest = (Chest)pos.getBlock().getBlockData();
            component = this.net.getComponent(this.shift(pos, chest.getType(), chest.getFacing()));
        }
        return component;
    }

    public Network networkWithComponentAt(Origin origin) {
        BlockLocation pos;
        Network network = this.net.getNetworkWithComponent(origin);
        if (network == null && origin instanceof BlockLocation && (pos = (BlockLocation)origin).getBlock().getType().equals((Object)Material.CHEST)) {
            Chest chest = (Chest)pos.getBlock().getBlockData();
            network = this.net.getNetworkWithComponent(this.shift(pos, chest.getType(), chest.getFacing()));
        }
        return network;
    }

    public void checkChest(Origin origin) {
        if (origin instanceof BlockLocation) {
            BlockLocation pos = (BlockLocation)origin;
            Block block = pos.getBlock();
            if (!block.getType().equals((Object)Material.CHEST) && !block.getType().equals((Object)Material.TRAPPED_CHEST)) {
                return;
            }
            Chest chest = (Chest)block.getBlockData();
            if (chest.getType().equals((Object)Chest.Type.SINGLE)) {
                return;
            }
            BasicComponent component = this.net.getComponent(pos);
            if (component == null) {
                return;
            }
            BasicComponent component2 = this.net.getComponent(this.shift(pos, chest.getType(), chest.getFacing()));
            if (component2 == null) {
                return;
            }
            chest.setType(Chest.Type.SINGLE);
            block.setBlockData((BlockData)chest);
        }
    }

    public void disconnectChests(BlockLocation pos) {
        Block block = pos.getBlock();
        if (!block.getType().equals((Object)Material.CHEST) && !block.getType().equals((Object)Material.TRAPPED_CHEST)) {
            return;
        }
        Chest chest = (Chest)block.getBlockData();
        if (chest.getType().equals((Object)Chest.Type.SINGLE)) {
            return;
        }
        BasicComponent component = this.net.getComponent(pos);
        if (component == null) {
            return;
        }
        Block block2 = this.shift(pos, chest.getType(), chest.getFacing()).getBlock();
        Chest chest2 = (Chest)block2.getBlockData();
        chest.setType(Chest.Type.SINGLE);
        block.setBlockData((BlockData)chest);
        chest2.setType(Chest.Type.SINGLE);
        block2.setBlockData((BlockData)chest2);
    }

    private BlockLocation shift(BlockLocation location, Chest.Type type, BlockFace face) {
        if (type.equals((Object)Chest.Type.LEFT)) {
            switch (face) {
                case NORTH: {
                    return new BlockLocation(location.getX() + 1, location.getY(), location.getZ(), location.getWorld());
                }
                case WEST: {
                    return new BlockLocation(location.getX(), location.getY(), location.getZ() - 1, location.getWorld());
                }
                case SOUTH: {
                    return new BlockLocation(location.getX() - 1, location.getY(), location.getZ(), location.getWorld());
                }
                case EAST: {
                    return new BlockLocation(location.getX(), location.getY(), location.getZ() + 1, location.getWorld());
                }
            }
        }
        if (type.equals((Object)Chest.Type.RIGHT)) {
            switch (face) {
                case NORTH: {
                    return new BlockLocation(location.getX() - 1, location.getY(), location.getZ(), location.getWorld());
                }
                case WEST: {
                    return new BlockLocation(location.getX(), location.getY(), location.getZ() + 1, location.getWorld());
                }
                case SOUTH: {
                    return new BlockLocation(location.getX() + 1, location.getY(), location.getZ(), location.getWorld());
                }
                case EAST: {
                    return new BlockLocation(location.getX(), location.getY(), location.getZ() - 1, location.getWorld());
                }
            }
        }
        return location;
    }
}

