/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.networks.storage;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import de.kwantux.networks.Main;
import de.kwantux.networks.component.BasicComponent;
import de.kwantux.networks.component.component.SortingContainer;
import de.kwantux.networks.component.util.ComponentType;
import de.kwantux.networks.storage.Storage;
import java.lang.reflect.Type;
import org.jetbrains.annotations.Nullable;

public class ComponentSerializer
implements JsonDeserializer<BasicComponent>,
JsonSerializer<BasicComponent> {
    @Nullable
    public BasicComponent deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Class<? extends BasicComponent> clazz;
        BasicComponent component;
        JsonObject jsonObject = json.getAsJsonObject();
        ComponentType type = ComponentType.get(jsonObject.get("type").getAsString());
        if (type == null) {
            throw new JsonParseException("Error while deserializing network component. Unknown type: " + jsonObject.get("type").getAsString());
        }
        if (type.equals(ComponentType.SORTING) && !jsonObject.get("filters").getAsJsonArray().isEmpty()) {
            try {
                jsonObject.get("filters").getAsJsonArray().get(0).getAsInt();
            }
            catch (NumberFormatException e) {
                jsonObject.add("filters", Storage.gson.toJsonTree((Object)SortingContainer.convertLegacyFilters((String[])jsonObject.get("filters").getAsJsonArray().asList().stream().map(jsonPrimitive -> jsonPrimitive.getAsString()).toArray(String[]::new))));
            }
        }
        if ((component = (BasicComponent)Storage.gson.fromJson(json, clazz = type.clazz)).isMissingData()) {
            Main.logger.severe("A network component is missing crucial data. It will be skipped during loading phase.");
            Main.logger.severe("If you did not manually edit the network files, report this to the Networks developers.");
            return null;
        }
        return component;
    }

    public JsonElement serialize(BasicComponent src, Type typeOfSrc, JsonSerializationContext context) {
        JsonElement jsonElement = Storage.gson.toJsonTree((Object)src);
        jsonElement.getAsJsonObject().addProperty("type", ComponentType.get(src.getClass()).tag());
        return jsonElement;
    }
}

