/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.networks.event;

import de.kwantux.networks.Main;
import de.kwantux.networks.Manager;
import de.kwantux.networks.Network;
import de.kwantux.networks.Sorter;
import de.kwantux.networks.component.BasicComponent;
import de.kwantux.networks.component.module.Donator;
import de.kwantux.networks.component.module.Requestor;
import de.kwantux.networks.utils.BlockLocation;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.plugin.Plugin;

public class ComponentDonateListener
implements Listener {
    private Manager manager;

    public ComponentDonateListener(Main plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.manager = plugin.getNetworkManager();
    }

    private void check(@Nullable Location location) {
        if (location == null) {
            return;
        }
        BlockLocation loc = new BlockLocation(location);
        BasicComponent component = Main.dcu.componentAt(loc);
        if (component != null) {
            Network network;
            if (component instanceof Donator) {
                Donator donator = (Donator)((Object)component);
                network = this.manager.getNetworkWithComponent(component.origin());
                if (network != null) {
                    Sorter.donate(network, donator);
                }
            }
            if (component instanceof Requestor) {
                Requestor requestor = (Requestor)((Object)component);
                network = this.manager.getNetworkWithComponent(component.origin());
                if (network != null) {
                    Sorter.request(network, requestor);
                }
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        this.check(event.getInventory().getLocation());
    }

    @EventHandler
    public void onItemTransmit(InventoryMoveItemEvent event) {
        Location location = event.getDestination().getLocation();
        if (location == null) {
            return;
        }
        Main.regionScheduler.execute((Plugin)Main.instance, location, () -> this.check(location));
    }

    @EventHandler
    public void onItemPickup(InventoryPickupItemEvent event) {
        Location location = event.getInventory().getLocation();
        if (location == null) {
            return;
        }
        Main.regionScheduler.execute((Plugin)Main.instance, location, () -> this.check(location));
    }
}

