/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.networks.config;

import de.kwantux.config.Configuration;
import de.kwantux.config.ConfigurationManager;
import de.kwantux.config.util.exceptions.ConfigAlreadyRegisteredException;
import de.kwantux.config.util.exceptions.InvalidNodeException;
import de.kwantux.networks.Main;
import de.kwantux.networks.compat.ConfigurationTransformers;
import de.kwantux.networks.component.util.ComponentType;
import de.kwantux.networks.storage.NetworkProperties;
import de.kwantux.networks.utils.BlockLocation;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.Material;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.serialize.SerializationException;

public class Config {
    Logger logger;
    Configuration config;
    public static boolean blastProofComponents;
    public static boolean noticeEnabled;
    public static boolean humanReadableJson;
    public static boolean archiveNetworksOnDelete;
    public static boolean requestOwnershipTransfers;
    public static boolean complexInventoryChecks;
    public static boolean propertyLore;
    public static boolean loadChunks;
    public static boolean rangePerNetwork;
    public static int autoSaveInterval;
    public static String[] commands;
    public static Integer[] ranges;

    public Config(Main main) throws SerializationException {
        this.logger = main.getLogger();
        try {
            this.config = Configuration.createMain((JavaPlugin)main, "general.conf");
            this.config.require("blastProofComponents");
            this.config.require("commands");
            this.config.require("notice");
            this.config.require("lang");
            this.config.require("range");
            this.config.require("maxNetworks");
            this.config.require("propertyLore");
            this.config.require("properties.baseRange", "properties.maxComponents", "properties.maxUsers");
            this.config.require("component.input", "component.sorting", "component.misc");
            this.config.require("material.component");
            this.config.require("material.range");
            this.config.require("performance.complexInventoryChecks", "performance.loadChunks");
            this.config.require("logoOnLaunch");
            this.config.require("requestOwnershipTransfers");
            this.config.require("humanReadableJson");
            this.config.require("archiveNetworksOnDelete");
            this.config.require("autoSave");
            this.config.require("rangePerNetwork");
            ConfigurationTransformers.generalConfigTransformers(this.config);
            this.config.update();
            blastProofComponents = this.config.getFinalBoolean("blastProofComponents");
            noticeEnabled = this.config.getFinalBoolean("notice");
            humanReadableJson = this.config.getFinalBoolean("humanReadableJson");
            archiveNetworksOnDelete = this.config.getFinalBoolean("archiveNetworksOnDelete");
            requestOwnershipTransfers = this.config.getFinalBoolean("requestOwnershipTransfers");
            complexInventoryChecks = this.config.getFinalBoolean("performance.complexInventoryChecks");
            propertyLore = this.config.getFinalBoolean("propertyLore");
            loadChunks = this.config.getFinalBoolean("performance.loadChunks");
            autoSaveInterval = this.config.getFinalInt("autoSave");
            commands = this.config.getFinalList("commands", String.class).toArray(new String[0]);
            ranges = this.config.getList("range", Integer.class).toArray(new Integer[0]);
            rangePerNetwork = this.config.getFinalBoolean("rangePerNetwork");
        }
        catch (ConfigAlreadyRegisteredException | InvalidNodeException e) {
            throw new RuntimeException(e);
        }
    }

    public void setLanguage(String language) {
        this.config.set("lang", language);
    }

    public String getLanguage() {
        return this.config.getFinalString("lang");
    }

    public List<Material> componentBlocks(ComponentType componentType) {
        ArrayList<Material> allowed = new ArrayList<Material>();
        this.config.getFinalList("component." + componentType.tag, String.class).forEach(mat -> allowed.add(Material.getMaterial((String)mat)));
        return allowed;
    }

    public boolean checkLocation(BlockLocation location, ComponentType componentType) {
        List<Material> whitelist = this.componentBlocks(componentType);
        for (Material mat : whitelist) {
            if (!location.getBukkitLocation().getBlock().getType().equals((Object)mat)) continue;
            return true;
        }
        return false;
    }

    public int getMaxNetworks() {
        return this.config.getFinalInt("maxNetworks");
    }

    public NetworkProperties defaultProperties() {
        return new NetworkProperties(this.config.getFinalInt("properties.baseRange"), this.config.getFinalInt("properties.maxComponents"), this.config.getFinalInt("properties.maxUsers"));
    }

    public Material getComponentUpgradeMaterial() {
        try {
            return Material.getMaterial((String)this.getString("material.component"));
        }
        catch (EnumConstantNotPresentException e) {
            this.logger.severe(this.getString("material.component") + " is not a valid material, please change your config!");
            return Material.ITEM_FRAME;
        }
    }

    public Material getRangeUpgradeMaterial() {
        try {
            return Material.getMaterial((String)this.getString("material.range"));
        }
        catch (EnumConstantNotPresentException e) {
            this.logger.severe(this.getString("material.range") + " is not a valid material, please change your config!");
            return Material.LIGHTNING_ROD;
        }
    }

    public boolean logoOnLaunch() {
        return Boolean.TRUE.equals(this.config.getFinalBoolean("logoOnLaunch"));
    }

    @Nullable
    private String getString(String path) {
        try {
            return this.config.getString(path);
        }
        catch (InvalidNodeException e) {
            this.logger.severe("");
            return null;
        }
    }

    public void reload() {
        this.config.reload();
        ConfigurationManager.saveAll();
        ConfigurationManager.reloadAll();
    }
}

