/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.networks.commands;

import de.kwantux.config.ConfigurationManager;
import de.kwantux.config.util.exceptions.InvalidNodeException;
import de.kwantux.manual.ManualManager;
import de.kwantux.networks.Main;
import de.kwantux.networks.Network;
import de.kwantux.networks.commands.CommandHandler;
import de.kwantux.networks.commands.ComponentTypeParser;
import de.kwantux.networks.commands.NetworkParser;
import de.kwantux.networks.component.BasicComponent;
import de.kwantux.networks.component.component.InputContainer;
import de.kwantux.networks.component.component.MiscContainer;
import de.kwantux.networks.component.component.SortingContainer;
import de.kwantux.networks.component.util.ComponentType;
import de.kwantux.networks.component.util.FilterTranslator;
import de.kwantux.networks.config.Config;
import de.kwantux.networks.utils.BlockLocation;
import de.kwantux.networks.utils.ItemHash;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.bukkit.parser.PlayerParser;
import org.incendo.cloud.bukkit.parser.location.LocationParser;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.parser.standard.IntegerParser;
import org.incendo.cloud.parser.standard.StringParser;
import org.incendo.cloud.setting.ManagerSetting;
import org.incendo.cloud.setting.Setting;
import org.jetbrains.annotations.Nullable;

public class NetworksCommand
extends CommandHandler {
    public NetworksCommand(Main plugin, CommandManager<CommandSender> commandManager) {
        super(plugin, commandManager);
    }

    @Override
    public void register() {
        this.cmd.settings().set((Setting)ManagerSetting.ALLOW_UNSAFE_REGISTRATION, true);
        this.cmd.command(this.cmd.commandBuilder("networks", Config.commands).handler(this::help));
        this.cmd.command(this.cmd.commandBuilder("networks", Config.commands).literal("help", new String[0]).handler(this::help));
        this.cmd.command(this.cmd.commandBuilder("networks", Config.commands).literal("manual", new String[0]).handler(this::manual));
        this.cmd.command(this.cmd.commandBuilder("networks", Config.commands).literal("version", new String[0]).handler(this::version));
        this.cmd.command(this.cmd.commandBuilder("networks", Config.commands).literal("force", new String[0]).permission("networks.force").handler(this::force));
        this.cmd.command(this.cmd.commandBuilder("networks", Config.commands).literal("create", new String[0]).required("id", StringParser.stringParser()).senderType(Player.class).handler(this::create).permission("networks.create"));
        this.cmd.command(this.cmd.commandBuilder("networks", Config.commands).literal("delete", new String[0]).required("network", NetworkParser.networkParser()).senderType(Player.class).handler(this::deleteAsk));
        this.cmd.command(this.cmd.commandBuilder("networks", Config.commands).literal("delete", new String[0]).required("network", NetworkParser.networkParser()).literal("confirm", new String[0]).senderType(Player.class).handler(this::delete));
        this.cmd.command(this.cmd.commandBuilder("networks", Config.commands).literal("select", new String[0]).required("network", NetworkParser.networkParser()).senderType(Player.class).handler(this::select));
        this.cmd.command(this.cmd.commandBuilder("networks", Config.commands).literal("rename", new String[0]).required("network", NetworkParser.networkParser()).required("newID", StringParser.stringParser()).handler(this::rename));
        this.cmd.command(this.cmd.commandBuilder("networks", Config.commands).literal("list", new String[0]).senderType(Player.class).handler(this::list));
        this.cmd.command(this.cmd.commandBuilder("networks", Config.commands).literal("list", new String[0]).required("player", PlayerParser.playerParser()).permission("networks.listforeign").handler(this::listForeign));
        this.cmd.command(this.cmd.commandBuilder("networks", Config.commands).literal("listall", new String[0]).permission("networks.listforeign").handler(this::getNetworks));
        this.cmd.command(this.cmd.commandBuilder("networks", Config.commands).literal("info", new String[0]).handler(this::info));
        this.cmd.command(this.cmd.commandBuilder("networks", Config.commands).literal("component", new String[0]).literal("list", new String[0]).handler(this::components));
        this.cmd.command(this.cmd.commandBuilder("networks", Config.commands).literal("component", new String[0]).literal("info", new String[0]).required("location", LocationParser.locationParser()).handler(this::componentInfo));
        this.cmd.command(this.cmd.commandBuilder("networks", Config.commands).literal("user", new String[0]).literal("add", new String[0]).required("player", PlayerParser.playerParser()).handler(this::addUser));
        this.cmd.command(this.cmd.commandBuilder("networks", Config.commands).literal("user", new String[0]).literal("remove", new String[0]).required("player", PlayerParser.playerParser()).handler(this::removeUser));
        this.cmd.command(this.cmd.commandBuilder("networks", Config.commands).literal("owner", new String[0]).required("player", PlayerParser.playerParser()).handler(this::owner));
        this.cmd.command(this.cmd.commandBuilder("networks", Config.commands).literal("accept", new String[0]).required("network", NetworkParser.networkParser()).handler(this::acceptTransfer));
        this.cmd.command(this.cmd.commandBuilder("networks", Config.commands).literal("merge", new String[0]).required("final", NetworkParser.networkParser()).required("other", NetworkParser.networkParser()).handler(this::merge));
        this.cmd.command(this.cmd.commandBuilder("networks", Config.commands).literal("items", new String[0]).handler(this::items));
        this.cmd.command(this.cmd.commandBuilder("networks", Config.commands).literal("data", new String[0]).literal("save", new String[0]).permission("networks.data").handler(this::saveNetworks));
        this.cmd.command(this.cmd.commandBuilder("networks", Config.commands).literal("data", new String[0]).literal("save", new String[0]).literal("networks", new String[0]).permission("networks.data").handler(this::saveNetworks));
        this.cmd.command(this.cmd.commandBuilder("networks", Config.commands).literal("data", new String[0]).literal("save", new String[0]).literal("config", new String[0]).permission("networks.data").handler(this::saveConfig));
        this.cmd.command(this.cmd.commandBuilder("networks", Config.commands).literal("data", new String[0]).literal("reload", new String[0]).permission("networks.data").handler(this::reloadConfig));
        this.cmd.command(this.cmd.commandBuilder("networks", Config.commands).literal("data", new String[0]).literal("reload", new String[0]).literal("networks", new String[0]).permission("networks.data").handler(this::reloadNetworks));
        this.cmd.command(this.cmd.commandBuilder("networks", Config.commands).literal("data", new String[0]).literal("reload", new String[0]).literal("config", new String[0]).permission("networks.data").handler(this::reloadConfig));
        this.cmd.command(this.cmd.commandBuilder("networks", Config.commands).literal("give", new String[0]).literal("wand", new String[0]).permission("networks.give").senderType(Player.class).handler(this::giveWand));
        this.cmd.command(this.cmd.commandBuilder("networks", Config.commands).literal("give", new String[0]).literal("component", new String[0]).required("type", ComponentTypeParser.componentTypeParser(true)).permission("networks.give").senderType(Player.class).handler(this::giveComponent));
        this.cmd.command(this.cmd.commandBuilder("networks", Config.commands).literal("give", new String[0]).literal("upgrade", new String[0]).literal("range", new String[0]).required("tier", IntegerParser.integerParser((int)1, (int)Config.ranges.length)).permission("networks.give").senderType(Player.class).handler(this::giveUpgradeRange));
        this.cmd.command(this.cmd.commandBuilder("networks", Config.commands).literal("debug", new String[0]).literal("itemhash", new String[0]).permission("networks.debug").senderType(Player.class).handler(this::debugItemHash));
    }

    @Nullable
    private Network selection(CommandSender sender) {
        Network network = Main.mgr.selection(sender);
        if (network == null) {
            Main.lang.message(sender, "select.noselection");
            return null;
        }
        return network;
    }

    private void help(CommandContext<CommandSender> context) {
        CommandSender sender = (CommandSender)context.sender();
        boolean admin = true;
        if (sender instanceof Player) {
            Player player = (Player)sender;
            admin = player.hasPermission("networks.admin");
        }
        if (admin) {
            Main.lang.message(sender, "help.admin", this.plugin.getPluginMeta().getVersion());
        } else {
            Main.lang.message(sender, "help", this.plugin.getPluginMeta().getVersion());
        }
    }

    private void manual(CommandContext<CommandSender> context) {
        ManualManager.open((Player)context.sender(), "networks.main");
    }

    private void version(CommandContext<CommandSender> context) {
        Main.lang.message((CommandSender)context.sender(), "version", this.plugin.getPluginMeta().getVersion());
    }

    private void force(CommandContext<CommandSender> context) {
        boolean active = Main.mgr.forceToggle((Player)context.sender());
        if (active) {
            Main.lang.message((CommandSender)context.sender(), "force.enable");
        } else {
            Main.lang.message((CommandSender)context.sender(), "force.disable");
        }
    }

    private void saveNetworks(CommandContext<CommandSender> context) {
        Main.mgr.saveData();
        Main.lang.message((CommandSender)context.sender(), "data.save.networks");
    }

    private void reloadNetworks(CommandContext<CommandSender> context) {
        Main.mgr.loadData();
        Main.lang.message((CommandSender)context.sender(), "data.reload.networks");
    }

    private void saveConfig(CommandContext<CommandSender> context) {
        ConfigurationManager.saveAll();
        Main.lang.message((CommandSender)context.sender(), "data.save.config");
    }

    private void reloadConfig(CommandContext<CommandSender> context) {
        ConfigurationManager.reloadAll();
        Main.lang.message((CommandSender)context.sender(), "data.reload.config");
    }

    private void create(CommandContext<Player> context) {
        String id = (String)context.get("id");
        if (!Network.validName(id)) {
            Main.lang.message((CommandSender)context.sender(), "create.illegal_name");
            return;
        }
        Player player = (Player)context.sender();
        if (Main.mgr.withOwner(player.getUniqueId()).size() >= Main.cfg.getMaxNetworks() && !player.hasPermission("networks.bypass_limit")) {
            Main.lang.message((CommandSender)context.sender(), "create.limit", player.displayName());
            return;
        }
        if (Main.mgr.getFromName(id) != null) {
            Main.lang.message((CommandSender)player, "create.exists");
            return;
        }
        if (!Main.mgr.create(id, player.getUniqueId())) {
            Main.lang.message((CommandSender)player, "create.unknown_fail");
            return;
        }
        Main.lang.message((CommandSender)player, "create.success", id);
        Main.mgr.select((CommandSender)player, Main.mgr.getFromName(id));
        Main.lang.message((CommandSender)player, "select.success", id);
    }

    private void deleteAsk(CommandContext<Player> context) {
        Network network = (Network)context.get("network");
        if (!Main.mgr.permissionOwner((CommandSender)context.sender(), network)) {
            Main.lang.message((CommandSender)context.sender(), "permission.owner");
            return;
        }
        Main.lang.message((CommandSender)context.sender(), "delete.confirm", network.name());
    }

    private void delete(CommandContext<Player> context) {
        Network network = (Network)context.get("network");
        Player player = (Player)context.sender();
        if (!Main.mgr.permissionOwner((CommandSender)player, network)) {
            Main.lang.message((CommandSender)player, "permission.owner");
            return;
        }
        String name = network.name();
        Main.mgr.delete(name);
        Main.lang.message((CommandSender)player, "delete.success", name);
    }

    private void select(CommandContext<Player> context) {
        Network network = (Network)context.get("network");
        Player player = (Player)context.sender();
        if (Main.mgr.permissionUser((CommandSender)player, network)) {
            Main.mgr.select((CommandSender)player, network);
            Main.lang.message((CommandSender)player, "select.success", network.name());
        } else {
            Main.lang.message((CommandSender)player, "permission.user");
        }
    }

    private void rename(CommandContext<CommandSender> context) {
        Network network = (Network)context.get("network");
        String newID = (String)context.get("newID");
        if (!Network.validName(newID)) {
            Main.lang.message((CommandSender)context.sender(), "create.illegal_name");
            return;
        }
        String oldID = network.name();
        CommandSender sender = (CommandSender)context.sender();
        if (Main.mgr.permissionOwner(sender, network)) {
            if (Main.mgr.rename(oldID, newID)) {
                Main.lang.message(sender, "rename.success", network.name());
            } else {
                Main.lang.message(sender, "rename.taken", newID);
            }
        } else {
            Main.lang.message(sender, "permission.owner");
        }
    }

    private void list(CommandContext<Player> context) {
        Player player = (Player)context.sender();
        List<Network> list = Main.mgr.withUser(player.getUniqueId());
        List<Network> owned = Main.mgr.withUser(player.getUniqueId());
        if (list.isEmpty()) {
            Main.lang.message((CommandSender)player, "list.empty");
        } else {
            if (owned.size() > 1) {
                Main.lang.message((CommandSender)player, "list.owned");
                for (Network network : owned) {
                    player.sendMessage(network.displayText());
                    list.remove(network);
                }
            }
            if (list.size() > 1) {
                Main.lang.message((CommandSender)player, "list");
            }
            for (Network network : list) {
                player.sendMessage(network.displayText());
            }
        }
    }

    private void getNetworks(CommandContext<CommandSender> context) {
        CommandSender sender = (CommandSender)context.sender();
        if (Main.mgr.getNetworks().isEmpty()) {
            Main.lang.message(sender, "list.all.empty");
            return;
        }
        Main.lang.message(sender, "list.all");
        for (Network network : Main.mgr.getNetworks()) {
            sender.sendMessage(network.displayText());
        }
    }

    private void listForeign(CommandContext<CommandSender> context) {
        Player player = (Player)context.get("player");
        CommandSender sender = (CommandSender)context.sender();
        List<Network> list = Main.mgr.withUser(player.getUniqueId());
        List<Network> owned = Main.mgr.withOwner(player.getUniqueId());
        if (list.isEmpty()) {
            Main.lang.message(sender, "list.foreign.empty", player.displayName());
        } else {
            if (owned.size() > 1) {
                Main.lang.message(sender, "list.foreign.owned", player.displayName());
                for (Network network : owned) {
                    sender.sendMessage(network.displayText());
                    list.remove(network);
                }
            }
            Main.lang.message(sender, "list.foreign", player.displayName());
            for (Network network : list) {
                sender.sendMessage(network.displayText());
            }
        }
    }

    private void info(CommandContext<CommandSender> context) {
        CommandSender sender = (CommandSender)context.sender();
        Network network = this.selection(sender);
        if (network == null) {
            return;
        }
        Main.lang.message(sender, "info.title");
        Main.lang.message(sender, "info.name", network.name());
        Main.lang.message(sender, "info.owner", Bukkit.getOfflinePlayer((UUID)network.owner()).getName());
        StringBuilder users = new StringBuilder();
        for (UUID uid : network.users()) {
            users.append(Bukkit.getOfflinePlayer((UUID)uid).getName()).append(",  ");
        }
        if (!users.isEmpty()) {
            users = new StringBuilder(users.substring(0, users.length() - 3));
        }
        Main.lang.message(sender, "info.users", users.toString());
        Main.lang.message(sender, "info.components.total", String.valueOf(network.components().size()));
        Main.lang.message(sender, "info.range", String.valueOf(network.properties().baseRange()));
    }

    private void components(CommandContext<CommandSender> context) {
        CommandSender sender = (CommandSender)context.sender();
        Network network = this.selection(sender);
        if (network == null) {
            return;
        }
        if (network.components().isEmpty()) {
            Main.lang.message(sender, "component.list.empty", network.name());
            return;
        }
        for (BasicComponent basicComponent : network.components()) {
            sender.sendMessage(((Component)Objects.requireNonNullElse(Main.lang.getFinal("item.name.component." + basicComponent.type().tag()), Component.text((String)("Unknown Component type: " + basicComponent.type().tag())))).append(Component.text((String)":  ").append(basicComponent.origin().displayText())).hoverEvent((HoverEventSource)HoverEvent.showText((Component)NetworksCommand.componentInfo(network, basicComponent, false))));
        }
    }

    private void componentInfo(CommandContext<CommandSender> context) {
        CommandSender sender = (CommandSender)context.sender();
        BlockLocation location = new BlockLocation((Location)context.get("location"));
        Network network = Main.dcu.networkWithComponentAt(location);
        BasicComponent component = Main.dcu.componentAt(location);
        if (component == null) {
            Main.lang.message(sender, "component.info.empty", location.toString());
            return;
        }
        boolean isProxy = network.getComponent(location) == null;
        sender.sendMessage(NetworksCommand.componentInfo(network, component, isProxy));
    }

    public static Component componentInfo(Network network, @Nullable BasicComponent component, boolean isProxy) {
        try {
            BasicComponent basicComponent = component;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{InputContainer.class, SortingContainer.class, MiscContainer.class}, (Object)basicComponent, n)) {
                case 0 -> {
                    InputContainer container = (InputContainer)basicComponent;
                    yield Main.lang.get("wand.info.input", new Component[]{network.displayText(), component.origin().displayText(), Component.text((String)String.valueOf(container.range()))});
                }
                case 1 -> {
                    SortingContainer container = (SortingContainer)basicComponent;
                    TextComponent filters = Component.text((String)"[");
                    Set filterSet = Arrays.stream(container.filters()).mapToObj(FilterTranslator::translate).collect(Collectors.toSet());
                    for (Component filter : filterSet) {
                        filters = filters.append(filter);
                        filters = filters.append((Component)Component.text((String)", "));
                    }
                    filters = filters.append((Component)Component.text((String)"]"));
                    yield Main.lang.get("wand.info.sorting", new Component[]{network.displayText(), component.origin().displayText(), Component.text((String)String.valueOf(container.acceptorPriority())), filters});
                }
                case 2 -> {
                    MiscContainer container = (MiscContainer)basicComponent;
                    yield Main.lang.get("wand.info.misc", new Component[]{network.displayText(), component.origin().displayText(), Component.text((String)String.valueOf(container.acceptorPriority()))});
                }
                default -> Component.empty();
            };
        }
        catch (InvalidNodeException e) {
            return Component.empty();
        }
    }

    private void addUser(CommandContext<CommandSender> context) {
        CommandSender sender = (CommandSender)context.sender();
        Player target = (Player)context.get("player");
        Network network = this.selection(sender);
        if (network == null) {
            return;
        }
        if (!Main.mgr.permissionOwner(sender, this.selection(sender))) {
            Main.lang.message(sender, "permission.owner");
            return;
        }
        if (network.users().contains(target.getUniqueId())) {
            Main.lang.message(sender, "user.add.nochange", new Component[]{Component.text((String)network.name()), target.displayName()});
            return;
        }
        network.addUser(target.getUniqueId());
        Main.lang.message(sender, "user.add", new Component[]{Component.text((String)network.name()), target.displayName()});
    }

    private void removeUser(CommandContext<CommandSender> context) {
        CommandSender sender = (CommandSender)context.sender();
        Player target = (Player)context.get("player");
        Network network = this.selection(sender);
        if (network == null) {
            return;
        }
        if (!Main.mgr.permissionOwner(sender, this.selection(sender))) {
            Main.lang.message(sender, "permission.owner");
            return;
        }
        if (!network.users().contains(target.getUniqueId())) {
            Main.lang.message(sender, "user.remove.nochange", new Component[]{Component.text((String)network.name()), target.displayName()});
            return;
        }
        network.removeUser(target.getUniqueId());
        Main.lang.message(sender, "user.remove", new Component[]{Component.text((String)network.name()), target.displayName()});
    }

    private void owner(CommandContext<CommandSender> context) {
        CommandSender sender = (CommandSender)context.sender();
        boolean request = Config.requestOwnershipTransfers && !sender.hasPermission("network.transfer_without_request");
        Player target = (Player)context.get("player");
        Network network = this.selection(sender);
        if (network == null) {
            return;
        }
        if (Main.mgr.withOwner(target.getUniqueId()).size() >= Main.cfg.getMaxNetworks() && !sender.hasPermission("networks.bypass_limit")) {
            Main.lang.message((CommandSender)context.sender(), "create.limit", target.displayName());
            return;
        }
        if (!Main.mgr.permissionOwner(sender, this.selection(sender))) {
            Main.lang.message(sender, "permission.owner");
            return;
        }
        if (target.getUniqueId().equals(network.owner())) {
            Main.lang.message(sender, "user.owner.nochange", new Component[]{Component.text((String)network.name()), target.displayName()});
            return;
        }
        if (request) {
            Main.lang.message(sender, "user.owner.request.donator", new Component[]{Component.text((String)network.name()), target.displayName()});
            Main.lang.message((CommandSender)target, "user.owner.request.acceptor", network.name(), Bukkit.getOfflinePlayer((UUID)network.owner()).getName());
            Main.mgr.requestTransfer(network, target);
        } else {
            network.removeUser(target.getUniqueId());
            network.addUser(network.owner());
            network.owner(target.getUniqueId());
        }
    }

    private void acceptTransfer(CommandContext<CommandSender> context) {
        Player sender = (Player)context.sender();
        Network network = (Network)context.get("network");
        if (!Main.mgr.canTransfer(network, sender)) {
            Main.lang.message((CommandSender)sender, "user.owner.norequest");
            return;
        }
        Main.lang.message((CommandSender)sender, "user.owner.accept.acceptor", new Component[]{Component.text((String)network.name())});
        Player owner = Bukkit.getPlayer((UUID)network.owner());
        if (owner != null) {
            Main.lang.message((CommandSender)owner, "user.owner.accept.donator", sender.displayName());
        }
        Main.mgr.acceptTransfer(network);
        network.removeUser(sender.getUniqueId());
        network.addUser(network.owner());
        network.owner(sender.getUniqueId());
    }

    private void merge(CommandContext<CommandSender> context) {
        Network finalNetwork = (Network)context.get("final");
        Network otherNetwork = (Network)context.get("other");
        CommandSender sender = (CommandSender)context.sender();
        if (!Main.mgr.permissionOwner(sender, finalNetwork) || !Main.mgr.permissionOwner(sender, otherNetwork)) {
            Main.lang.message(sender, "merge.nopermission");
            return;
        }
        if (finalNetwork.equals(otherNetwork)) {
            Main.lang.message(sender, "merge.identical");
        }
        String otherName = otherNetwork.name();
        Main.mgr.delete(otherName);
        Main.lang.message(sender, "merge.success", new Component[]{Component.text((String)finalNetwork.name()), Component.text((String)otherName)});
    }

    private void items(CommandContext<CommandSender> context) {
        CommandSender sender = (CommandSender)context.sender();
        Network network = this.selection(sender);
        if (network == null) {
            return;
        }
        if (!Main.mgr.permissionUser(sender, network)) {
            Main.lang.message(sender, "permission.user");
            return;
        }
        HashMap<Material, Integer> materials = network.materials();
        if (materials.isEmpty()) {
            Main.lang.message(sender, "items.noitems");
            return;
        }
        Main.lang.message(sender, "items.message", new Component[]{Component.text((String)network.name())});
        for (Map.Entry<Material, Integer> entry : materials.entrySet()) {
            sender.sendMessage(((TranslatableComponent)Component.translatable((String)entry.getKey().translationKey()).append(((TextComponent)((TextComponent)Component.text((String)":  ").color(TextColor.color((int)0, (int)255, (int)230))).append((Component)Component.text((int)entry.getValue()))).color(TextColor.color((int)255, (int)255, (int)255)))).hoverEvent((HoverEventSource)HoverEvent.showItem((HoverEvent.ShowItem)HoverEvent.ShowItem.showItem((Key)entry.getKey().key(), (int)1))));
        }
    }

    private void giveWand(CommandContext<Player> context) {
        Player player = (Player)context.sender();
        ItemStack wand = Main.crf.getNetworkWand(2);
        player.getInventory().addItem(new ItemStack[]{wand});
    }

    private void giveUpgradeRange(CommandContext<Player> context) {
        Player player = (Player)context.sender();
        try {
            ItemStack upgrade = Main.crf.getRangeUpgrade((Integer)context.get("tier"));
            player.getInventory().addItem(new ItemStack[]{upgrade});
        }
        catch (InvalidNodeException e) {
            throw new RuntimeException(e);
        }
    }

    private void giveComponent(CommandContext<Player> context) {
        Player player = (Player)context.sender();
        ComponentType type = (ComponentType)context.get("type");
        player.getInventory().addItem(new ItemStack[]{type.item()});
    }

    private void debugItemHash(CommandContext<Player> context) {
        Player player = (Player)context.sender();
        ItemStack item = player.getInventory().getItemInMainHand();
        player.sendMessage(item.getType().ordinal() + " ");
        try {
            player.sendMessage(item.getType().getId() + " ");
        }
        catch (Throwable e) {
            player.sendMessage("modern ");
        }
        Main.lang.message((CommandSender)player, "debug.hash", "" + ItemHash.materialHash(item), "" + ItemHash.strictHash(item), "");
    }
}

