/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.networks.commands;

import de.kwantux.networks.component.util.ComponentType;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.caption.Caption;
import org.incendo.cloud.caption.CaptionVariable;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.exception.parsing.ParserException;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.parser.ParserDescriptor;
import org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import org.jetbrains.annotations.NotNull;

public final class ComponentTypeParser
implements ArgumentParser<CommandSender, ComponentType>,
BlockingSuggestionProvider.Strings<CommandSender> {
    private boolean mustBePersistentComponentType;

    public static @NonNull ParserDescriptor<CommandSender, ComponentType> componentTypeParser(boolean mustBePersistentComponentType) {
        return ParserDescriptor.of((ArgumentParser)new ComponentTypeParser(mustBePersistentComponentType), ComponentType.class);
    }

    public ComponentTypeParser(boolean mustBePhysicalComponentType) {
        this.mustBePersistentComponentType = mustBePhysicalComponentType;
    }

    @NotNull
    public ArgumentParseResult<ComponentType> parse(@NotNull CommandContext<CommandSender> context, @NotNull CommandInput inputQueue) {
        String input = inputQueue.readString();
        ComponentType componentType = ComponentType.get(input);
        if (componentType == null) {
            return ArgumentParseResult.failure((Throwable)((Object)new ComponentTypeParseException(input, context)));
        }
        if (this.mustBePersistentComponentType && !componentType.persistent) {
            return ArgumentParseResult.failure((Throwable)((Object)new ComponentTypeParseException(input, context)));
        }
        return ArgumentParseResult.success((Object)componentType);
    }

    @NotNull
    public @NotNull List<@NotNull String> stringSuggestions(@NotNull CommandContext<CommandSender> commandContext, @NotNull CommandInput input) {
        ArrayList<String> output = new ArrayList<String>();
        for (ComponentType componentType : ComponentType.types.values()) {
            if (this.mustBePersistentComponentType && !componentType.persistent) continue;
            output.add(componentType.tag);
        }
        return output;
    }

    public static final class ComponentTypeParseException
    extends ParserException {
        private final String input;

        public ComponentTypeParseException(@NotNull String input, @NotNull CommandContext<?> context) {
            super(ComponentTypeParser.class, context, Caption.of((String)"argument.parse.failure.componenttype"), new CaptionVariable[]{CaptionVariable.of((String)"input", (String)input)});
            this.input = input;
        }

        @NotNull
        public String getInput() {
            return this.input;
        }
    }
}

