/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.networks;

import de.kwantux.networks.Main;
import de.kwantux.networks.Network;
import de.kwantux.networks.component.BasicComponent;
import de.kwantux.networks.component.util.ComponentType;
import de.kwantux.networks.component.util.FilterTranslator;
import de.kwantux.networks.storage.Storage;
import de.kwantux.networks.utils.DoubleChestUtils;
import de.kwantux.networks.utils.Origin;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.jetbrains.annotations.NotNull;

public final class Manager {
    private final Storage storage;
    private final DoubleChestUtils dcu;
    private HashMap<String, Network> networks = new HashMap();
    private HashMap<Origin, Network> origins = new HashMap();
    private HashMap<CommandSender, Network> selections = new HashMap();
    private final ArrayList<UUID> forceMode = new ArrayList();
    private final Logger logger;
    Map<Network, Player> transferRequests = new HashMap<Network, Player>();

    public Manager(Main plugin) {
        this.storage = new Storage(plugin);
        this.logger = plugin.getLogger();
        this.dcu = new DoubleChestUtils(this);
    }

    public boolean create(String name, UUID owner) {
        if (this.networks.get(name) == null) {
            this.networks.put(name, new Network(name, owner));
            this.storage.create(name, owner);
            return true;
        }
        return false;
    }

    public boolean delete(String id) {
        if (this.networks.get(id) != null) {
            this.transferRequests.remove(this.networks.get(id));
            this.origins.values().removeIf(network -> network.name().equals(id));
            this.selections.values().removeIf(network -> network.name().equals(id));
            this.networks.remove(id);
            this.storage.delete(id);
            return true;
        }
        return false;
    }

    public boolean rename(String name, String newname) {
        Network network = this.networks.get(name);
        if (network == null) {
            return false;
        }
        if (this.networks.get(newname) != null) {
            return false;
        }
        network.name(newname);
        this.storage.renameNetwork(name, newname);
        this.networks.remove(name);
        this.networks.put(newname, network);
        return true;
    }

    public Collection<Network> getNetworks() {
        return this.networks.values();
    }

    public Set<String> getNetworkIDs() {
        return this.networks.keySet();
    }

    public void loadData() {
        this.networks.clear();
        for (String id : this.storage.getNetworkIDs()) {
            Network network = this.storage.loadNetwork(id);
            if (network == null) continue;
            this.networks.put(id, network);
            for (BasicComponent basicComponent : this.networks.get(id).components()) {
                this.origins.put(basicComponent.origin(), this.networks.get(id));
            }
        }
        this.logger.info("Loaded " + this.networks.size() + " Networks");
    }

    public void saveData() {
        for (String id : this.networks.keySet()) {
            this.storage.saveNetwork(id, this.networks.get(id));
        }
        try {
            FilterTranslator.save();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Network getFromName(String name) {
        return this.networks.get(name);
    }

    public void createComponent(Network network, ComponentType type, Origin origin, PersistentDataContainer container) {
        BasicComponent component = type.create(origin, container);
        this.addComponent(network, component);
    }

    public boolean addComponent(Network network, BasicComponent component) {
        if (component == null) {
            return false;
        }
        if (this.origins.containsKey(component.origin())) {
            return false;
        }
        network.addComponent(component);
        this.origins.put(component.origin(), network);
        this.dcu.checkChest(component.origin());
        return true;
    }

    public void removeComponent(Network network, BasicComponent component) {
        if (!this.origins.containsKey(component.origin())) {
            throw new IllegalArgumentException("Component " + String.valueOf(component) + " does not exist");
        }
        network.removeComponent(component);
        this.origins.remove(component.origin());
    }

    public void removeComponent(Origin component) {
        if (!this.origins.containsKey(component)) {
            throw new IllegalArgumentException("Component " + String.valueOf(component) + " does not exist");
        }
        this.origins.get(component).removeComponent(component);
        this.origins.remove(component);
    }

    public BasicComponent getComponent(@NotNull Origin location) {
        Network network = this.getNetworkWithComponent(location);
        if (network == null) {
            return null;
        }
        return network.getComponent(location);
    }

    public Network getNetworkWithComponent(@NotNull Origin location) {
        Network network = null;
        for (Origin loc : this.origins.keySet()) {
            if (!location.equals(loc)) continue;
            network = this.origins.get(loc);
            break;
        }
        if (network == null) {
            return null;
        }
        return network;
    }

    public List<Network> withUser(UUID user) {
        ArrayList<Network> result = new ArrayList<Network>();
        for (Network net : this.networks.values()) {
            if (!net.users().contains(user) && !net.owner().equals(user)) continue;
            result.add(net);
        }
        return result;
    }

    public List<Network> withOwner(UUID user) {
        ArrayList<Network> result = new ArrayList<Network>();
        for (Network net : this.networks.values()) {
            if (!net.owner().equals(user)) continue;
            result.add(net);
        }
        return result;
    }

    @Nullable
    public Network selection(CommandSender sender) {
        return this.selections.get(sender);
    }

    public void select(CommandSender sender, Network network) {
        this.selections.put(sender, network);
    }

    public boolean permissionOwner(CommandSender sender, Network network) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            return network.owner().equals(player.getUniqueId()) || this.force(player);
        }
        return true;
    }

    public boolean permissionUser(CommandSender sender, Network network) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            return network.owner().equals(player.getUniqueId()) || network.users().contains(player.getUniqueId()) || this.force(player);
        }
        return true;
    }

    public boolean force(Player player) {
        return this.forceMode.contains(player.getUniqueId());
    }

    public boolean forceToggle(Player player) {
        if (this.force(player)) {
            this.forceMode.remove(player.getUniqueId());
            return false;
        }
        this.forceMode.add(player.getUniqueId());
        return true;
    }

    public boolean canTransfer(Network network, Player player) {
        if (this.transferRequests.containsKey(network)) {
            return this.transferRequests.get(network).equals((Object)player);
        }
        return false;
    }

    public void acceptTransfer(Network network) {
        this.transferRequests.remove(network);
    }

    public void requestTransfer(Network network, Player player) {
        this.transferRequests.put(network, player);
    }
}

