/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.networks;

import de.kwantux.config.lang.LanguageController;
import de.kwantux.manual.Manual;
import de.kwantux.networks.Manager;
import de.kwantux.networks.commands.NetworksCommandManager;
import de.kwantux.networks.component.util.FilterTranslator;
import de.kwantux.networks.config.Config;
import de.kwantux.networks.config.CraftingManager;
import de.kwantux.networks.event.BlockBreakListener;
import de.kwantux.networks.event.ClearFilterListener;
import de.kwantux.networks.event.ComponentDonateListener;
import de.kwantux.networks.event.ComponentInstallListener;
import de.kwantux.networks.event.NoticeListener;
import de.kwantux.networks.event.PlayerJoinListener;
import de.kwantux.networks.event.WandListener;
import de.kwantux.networks.utils.DoubleChestUtils;
import de.kwantux.networks.utils.FoliaUtils;
import de.kwantux.networks.utils.Metrics;
import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.RegionScheduler;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.spongepowered.configurate.serialize.SerializationException;

public final class Main
extends JavaPlugin {
    public static Main instance;
    public static Logger logger;
    public static RegionScheduler regionScheduler;
    public static GlobalRegionScheduler globalRegionScheduler;
    public static AsyncScheduler asyncScheduler;
    public static Manager mgr;
    public static Config cfg;
    public static CraftingManager crf;
    public static DoubleChestUtils dcu;
    public static LanguageController lang;
    private final String startMessage = "\n\n   _  __    __                  __          ____  ___\n  / |/ /__ / /__    _____  ____/ /__ ___   |_  / <  /\n /    / -_) __/ |/|/ / _ \\/ __/  '_/(_-<  _/_ <_ / / \n/_/|_/\\__/\\__/|__,__/\\___/_/ /_/\\_\\/___/ /____(_)_/                                                            \n";

    public void onEnable() {
        instance = this;
        try {
            Files.createDirectories(Path.of(this.getDataFolder().getAbsolutePath(), "networks"), new FileAttribute[0]);
            Files.createDirectories(Path.of(this.getDataFolder().getAbsolutePath(), "manuals"), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (Files.exists(Path.of(this.getDataFolder().getAbsolutePath(), "networks.conf"), new LinkOption[0])) {
            try {
                Files.move(Path.of(this.getDataFolder().getAbsolutePath(), "networks.conf"), Path.of(this.getDataFolder().getAbsolutePath(), "general.conf"), new CopyOption[0]);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.saveResource("README.md", true);
        this.saveResource("manuals/main/de.yml", true);
        this.saveResource("manuals/main/en.yml", true);
        logger = this.getLogger();
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        try {
            logger.info("Loading config files...");
            cfg = new Config(this);
        }
        catch (SerializationException e) {
            logger.severe("Unable to load config, shutting down plugin\u2026");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            throw new RuntimeException(e);
        }
        lang = new LanguageController(this, cfg.getLanguage(), "en", "de");
        new NetworksCommandManager(this);
        regionScheduler = this.getServer().getRegionScheduler();
        globalRegionScheduler = this.getServer().getGlobalRegionScheduler();
        asyncScheduler = this.getServer().getAsyncScheduler();
        try {
            FilterTranslator.load(Path.of(this.getDataFolder().getAbsolutePath(), "filters.txt"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        mgr = new Manager(this);
        crf = new CraftingManager(this);
        new Manual(this, "main", cfg.getLanguage());
        int pluginId = 18609;
        Metrics metrics = new Metrics(this, pluginId);
        metrics.addCustomChart(new Metrics.SingleLineChart("total_networks", () -> mgr.getNetworks().size()));
        dcu = new DoubleChestUtils(mgr);
        mgr.loadData();
        mgr.saveData();
        new ComponentDonateListener(this);
        new ComponentInstallListener(this);
        new BlockBreakListener(this);
        new WandListener(this);
        new PlayerJoinListener(this);
        new NoticeListener(this);
        new ClearFilterListener(this);
        if (FoliaUtils.folia) {
            logger.warning("Folia support on Networks is still in beta, please report any bugs.");
            Integer[] integerArray = Config.ranges;
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int i2 = integerArray[i];
                if (i2 <= 1000) continue;
                logger.warning("You are running Networks on Folia and enabled a maximum network range of more than 1000 blocks. Be aware that on Folia, you might not be able to transmit items that far.");
                break;
            }
        }
        if (Config.autoSaveInterval > 0) {
            asyncScheduler.runAtFixedRate((Plugin)this, t -> mgr.saveData(), (long)Config.autoSaveInterval, (long)Config.autoSaveInterval, TimeUnit.SECONDS);
        }
        if (cfg.logoOnLaunch()) {
            logger.info("\n\n   _  __    __                  __          ____  ___\n  / |/ /__ / /__    _____  ____/ /__ ___   |_  / <  /\n /    / -_) __/ |/|/ / _ \\/ __/  '_/(_-<  _/_ <_ / / \n/_/|_/\\__/\\__/|__,__/\\___/_/ /_/\\_\\/___/ /____(_)_/                                                            \n");
        }
    }

    public void onDisable() {
        if (mgr != null) {
            mgr.saveData();
        }
    }

    public LanguageController getLanguage() {
        return lang;
    }

    public Manager getNetworkManager() {
        return mgr;
    }

    public Config getConfiguration() {
        return cfg;
    }
}

