/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.manual;

import de.kwantux.manual.ManualManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public class Manual {
    private final MiniMessage mm;
    protected JavaPlugin plugin;
    protected Logger logger;
    protected List<String> requirements = new ArrayList<String>();
    protected String path;
    private String language;
    private YamlConfigurationLoader loader;
    private CommentedConfigurationNode root;
    private final String id;
    private Book book;

    public Manual(JavaPlugin plugin, String id, String language) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.path = plugin.getName().toLowerCase() + ".manual." + language;
        this.id = id;
        this.mm = MiniMessage.miniMessage();
        this.logger = plugin.getLogger();
        this.language = language;
        this.build();
        ManualManager.register(this);
    }

    public void require(String path) {
        if (!this.requirements.contains(path)) {
            this.requirements.add(path);
        }
    }

    public void require(List<String> paths) {
        this.requirements.addAll(paths);
    }

    public void unrequire(String path) {
        this.requirements.remove(path);
    }

    public boolean testRequirements() {
        boolean result = true;
        for (String req : this.requirements) {
            if (this.has(req)) continue;
            this.logger.severe("[Manuals] File '" + this.path + "' is missing option: " + req);
            result = false;
        }
        return result;
    }

    private boolean has(String req) {
        return !((CommentedConfigurationNode)this.root.node(new Object[]{this.path})).isNull();
    }

    public void reload() {
        Path path = Paths.get(this.plugin.getDataFolder().getAbsolutePath() + "/manuals/" + this.id + "/" + this.language + ".yml", new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            this.language = "en";
            this.path = this.plugin.getName().toLowerCase() + ".manual." + this.language;
            path = Paths.get(this.plugin.getDataFolder().getAbsolutePath() + "/manuals/" + this.id + "/" + this.language + ".yml", new String[0]);
        }
        this.loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(path)).build();
        try {
            this.root = (CommentedConfigurationNode)this.loader.load();
            if (this.root == null) {
                this.logger.severe("[Manuals] Failed to load configuration " + this.language + ".yml, root configuration is null");
                Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
            }
        }
        catch (ConfigurateException e) {
            this.logger.severe("[Manuals] Could not load configuration " + this.language + ".yml: Invalid Syntax");
            throw new RuntimeException(e);
        }
        if (this.testRequirements()) {
            this.logger.info("[Manuals] Successfully loaded configuration file " + this.language + ".yml on root path " + String.valueOf(path));
        }
    }

    public void build() {
        this.reload();
        ArrayList<Component> pages = new ArrayList<Component>();
        try {
            for (String node : ((CommentedConfigurationNode)this.root.node(new Object[]{"pages"})).getList(String.class)) {
                pages.add(this.mm.deserialize((Object)node));
            }
            this.book = Book.book((Component)Component.text((String)((CommentedConfigurationNode)this.root.node(new Object[]{"name"})).getString()), (Component)Component.text((String)((CommentedConfigurationNode)this.root.node(new Object[]{"author"})).getString()), pages);
        }
        catch (NullPointerException | SerializationException e) {
            this.logger.severe("[Manuals] Language file " + this.path + " has an invalid format. Try to restart the server.");
            throw new RuntimeException(e);
        }
    }

    public void show(@NotNull Player player) {
        player.openBook(this.book);
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public String getRegistrationID() {
        return this.id + "." + this.plugin.getName();
    }

    public Book getBook() {
        return this.book;
    }
}

