/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.config.lang;

import de.kwantux.config.RawConfiguration;
import de.kwantux.config.util.exceptions.InvalidNodeException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ScopedConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public class Language
extends RawConfiguration {
    private final MiniMessage mm = MiniMessage.miniMessage();
    private final String langID;
    private final YamlConfigurationLoader loader;
    private CommentedConfigurationNode root;

    public Language(@NotNull JavaPlugin plugin, @NotNull String langID) throws SerializationException {
        this.plugin = plugin;
        this.langID = langID;
        this.path = plugin.getName().toLowerCase() + ".lang." + langID;
        this.logger = plugin.getLogger();
        this.loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(Paths.get(plugin.getDataFolder().getAbsolutePath() + "/lang/" + langID + ".yml", new String[0]))).build();
        this.update();
    }

    @Override
    protected void update() {
        this.reload();
        try {
            this.plugin.saveResource("lang/" + this.langID + ".yml", true);
        }
        catch (Exception ignore) {
            return;
        }
        CommentedConfigurationNode defaultConfig = null;
        try {
            YamlConfigurationLoader defaultLoader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(Paths.get(this.plugin.getDataFolder().getAbsolutePath() + "/lang/" + this.langID + ".yml", new String[0]))).build();
            defaultConfig = (CommentedConfigurationNode)defaultLoader.load();
        }
        catch (ConfigurateException e) {
            this.logger.severe("[QC] Error while loading default config file from jar class");
            Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
            throw new RuntimeException(e);
        }
        if (defaultConfig == null) {
            this.logger.severe("[QC] Error while loading default config file from jar class");
            Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
        }
        this.root = (CommentedConfigurationNode)this.root.mergeFrom((ConfigurationNode)defaultConfig);
        try {
            this.loader.save((ConfigurationNode)this.root);
        }
        catch (ConfigurateException e) {
            this.logger.severe("[QC] Unable to update configuration file " + this.langID + ".yml:\n" + e.getMessage());
            return;
        }
        this.logger.info("[QC] Successfully updated config file " + this.langID + ".yml");
    }

    @Override
    public void reload() {
        try {
            this.root = (CommentedConfigurationNode)this.loader.load();
            if (this.root == null) {
                this.logger.severe("[QC] Failed to load configuration " + this.langID + ".yml, root configuration is null");
                Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
            }
        }
        catch (ConfigurateException e) {
            this.logger.severe("[QC] Could not load configuration " + this.langID + ".yml: Invalid Syntax");
            throw new RuntimeException(e);
        }
        if (this.testRequirements()) {
            this.logger.info("[QC] Successfully loaded configuration file " + this.langID + ".yml on root path " + this.path);
        }
    }

    @Override
    public void save() {
        try {
            this.loader.save((ConfigurationNode)this.root);
        }
        catch (ConfigurateException e) {
            this.logger.severe("[QC] Unable to save configuration file " + this.langID + ".yml:\n" + e.getMessage());
        }
    }

    @Override
    public ConfigurationNode get(String path) throws InvalidNodeException {
        return null;
    }

    @Override
    public void set(String path, Object value) throws org.apache.commons.lang3.SerializationException {
    }

    public String getRaw(@NotNull String path) throws InvalidNodeException {
        ScopedConfigurationNode node = this.root.node(new Object[]{path});
        if (node.isNull()) {
            throw new InvalidNodeException("[QC] Node " + path + " in configuration " + this.path + " does not exist!");
        }
        if (node.getString() == null || node.getString() == "") {
            throw new InvalidNodeException("[QC] Node " + path + " in configuration " + this.path + " does not exist!");
        }
        return node.getString();
    }

    @NotNull
    public String getPreparedString(@NotNull String path) throws InvalidNodeException {
        String result = this.getRaw(path);
        ScopedConfigurationNode prefix = this.root.node(new Object[]{"prefix"});
        if (!prefix.isNull()) {
            result = result.replaceAll("<prefix>", prefix.getString() + "<reset>");
        }
        for (String key : this.getKeys()) {
            result = result.replaceAll("<replace: '" + key + "'>", this.getPreparedString(key)).replaceAll("<replace: \"" + key + "\">", this.getPreparedString(key)).replaceAll("<replace: " + key + ">", this.getPreparedString(key)).replaceAll("<replace:'" + key + "'>", this.getPreparedString(key)).replaceAll("<replace:\"" + key + "\">", this.getPreparedString(key)).replaceAll("<replace:" + key + ">", this.getPreparedString(key));
        }
        return result;
    }

    private List<String> getKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        for (ConfigurationNode node : this.root.childrenList()) {
            for (ConfigurationNode node1 : node.childrenList()) {
                for (ConfigurationNode node2 : node1.childrenList()) {
                    keys.add(String.valueOf(node.key()) + "." + String.valueOf(node1.key()) + "." + String.valueOf(node2.key()));
                }
                keys.add(String.valueOf(node.key()) + "." + String.valueOf(node1.key()));
            }
            keys.add(node.key().toString());
        }
        return keys;
    }

    @Nullable
    public List<String> getList(@NotNull String path) throws InvalidNodeException {
        ScopedConfigurationNode node = this.root.node(new Object[]{path});
        if (node.isNull()) {
            throw new InvalidNodeException("[QC] Node " + path + " in configuration " + this.path + " does not exist!");
        }
        try {
            return node.getList(String.class);
        }
        catch (SerializationException e) {
            throw new RuntimeException("[QC] Node " + path + " in configuration " + this.path + " appears to not be a list: " + String.valueOf((Object)e));
        }
    }

    public void set(@NotNull String path, String value) throws SerializationException {
        ((CommentedConfigurationNode)this.root.node(new Object[]{path})).set((Object)value);
    }

    @Override
    public boolean has(@NotNull String path) {
        return !((CommentedConfigurationNode)this.root.node(new Object[]{path})).isNull();
    }

    @Override
    public JavaPlugin getPlugin() {
        return this.plugin;
    }
}

