/*
 * Decompiled with CFR 0.152.
 */
package de.kwantux.config;

import de.kwantux.config.ConfigurationManager;
import de.kwantux.config.RawConfiguration;
import de.kwantux.config.util.exceptions.ConfigAlreadyRegisteredException;
import de.kwantux.config.util.exceptions.InvalidNodeException;
import de.kwantux.networks.Main;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ScopedConfigurationNode;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.configurate.serialize.SerializationException;

public final class Configuration
extends RawConfiguration {
    private final boolean logging = true;
    private final String filepath;
    private final String filename;
    private final HoconConfigurationLoader loader;
    private CommentedConfigurationNode root;

    @ApiStatus.Internal
    private Configuration(JavaPlugin plugin, String registeredPath, Path filePath) throws ConfigAlreadyRegisteredException {
        this.plugin = plugin;
        this.path = registeredPath == null || registeredPath.equals("") ? plugin.getName().toLowerCase() : plugin.getName().toLowerCase() + "." + registeredPath;
        this.filename = filePath.toFile().getName();
        this.filepath = filePath.toFile().getPath().replace(plugin.getDataFolder().getPath() + "/", "").replace(plugin.getDataFolder().getPath() + "\\", "");
        this.loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(Paths.get(plugin.getDataFolder().getAbsolutePath() + "/" + this.filename, new String[0]))).build();
        this.logger = plugin.getLogger();
        ConfigurationManager.addConfiguration(this);
    }

    @Override
    public void update() {
        this.reload();
        this.resolveTransformations(new ComparableVersion(Objects.requireNonNullElse(this.getFinalStringSilent("version"), "0.0.0")), new ComparableVersion(((Main)Main.getPlugin(Main.class)).getPluginMeta().getVersion()));
        this.set("version", ((Main)Main.getPlugin(Main.class)).getPluginMeta().getVersion());
        try {
            this.plugin.saveResource(this.filepath, true);
        }
        catch (IllegalArgumentException e) {
            this.logger.severe("[QC] Unable to update configuration file " + this.filename + ":");
            this.logger.severe("[QC] No such file called '" + this.filepath + "'");
            this.logger.severe("[QC] This is a bug in either QuillConfig or this plugin, please contact the developers of the plugin and the developers of QuillConfig");
            Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
        }
        CommentedConfigurationNode defaultConfig = null;
        try {
            HoconConfigurationLoader defaultLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(Paths.get(this.plugin.getDataFolder().getAbsolutePath() + "/" + this.filename, new String[0]))).build();
            defaultConfig = (CommentedConfigurationNode)defaultLoader.load();
        }
        catch (ConfigurateException e) {
            this.logger.severe("[QC] Error while loading default config file from jar class:");
            new RuntimeException(e);
        }
        if (defaultConfig == null) {
            this.logger.severe("[QC] Error while loading default config file from jar class");
            new RuntimeException("Default config is null!");
        }
        this.root = (CommentedConfigurationNode)this.root.mergeFrom(defaultConfig);
        try {
            this.loader.save((ConfigurationNode)this.root);
        }
        catch (ConfigurateException e) {
            this.logger.severe("[QC] Unable to update configuration file " + this.filename + ":");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
        }
        if (this.testRequirements()) {
            this.logger.info("[QC] Successfully updated config file " + this.filename);
        }
    }

    public static Configuration createMain(JavaPlugin plugin, File file) throws ConfigAlreadyRegisteredException {
        return new Configuration(plugin, "", Paths.get(file.getAbsolutePath(), new String[0]));
    }

    public static Configuration create(JavaPlugin plugin, String registeredPath, File file) throws ConfigAlreadyRegisteredException {
        return new Configuration(plugin, registeredPath, Paths.get(file.getAbsolutePath(), new String[0]));
    }

    public static Configuration createMain(JavaPlugin plugin, String filename) throws ConfigAlreadyRegisteredException {
        if (filename.endsWith(".conf")) {
            filename = filename.substring(0, filename.length() - 5);
        }
        return new Configuration(plugin, "", Paths.get(String.valueOf(plugin.getDataFolder()) + "/" + filename + ".conf", new String[0]));
    }

    public static Configuration create(JavaPlugin plugin, String registeredPath, String filename) throws ConfigAlreadyRegisteredException {
        if (filename.endsWith(".conf")) {
            filename = filename.substring(0, filename.length() - 5);
        }
        return new Configuration(plugin, registeredPath, Paths.get(String.valueOf(plugin.getDataFolder()) + "/" + filename + ".conf", new String[0]));
    }

    public static Configuration createMain(JavaPlugin plugin, String filepath, String filename) throws ConfigAlreadyRegisteredException {
        if (filename.endsWith(".conf")) {
            filename = filename.substring(0, filename.length() - 5);
        }
        if (filepath.endsWith("/")) {
            filepath = filepath.substring(0, filepath.length() - 1);
        }
        if (filepath.startsWith("/")) {
            filepath = filepath.substring(1);
        }
        return new Configuration(plugin, "", Paths.get(String.valueOf(plugin.getDataFolder()) + "/" + filepath + "/" + filename + ".conf", new String[0]));
    }

    public static Configuration create(JavaPlugin plugin, String registeredPath, String filepath, String filename) throws ConfigAlreadyRegisteredException {
        if (filename.endsWith(".conf")) {
            filename = filename.substring(0, filename.length() - 5);
        }
        if (filepath.endsWith("/")) {
            filepath = filepath.substring(0, filepath.length() - 1);
        }
        if (filepath.startsWith("/")) {
            filepath = filepath.substring(1);
        }
        return new Configuration(plugin, registeredPath, Paths.get(String.valueOf(plugin.getDataFolder()) + "/" + filepath + "/" + filename + ".conf", new String[0]));
    }

    @Override
    public void reload() {
        this.logger = this.plugin.getLogger();
        try {
            this.root = (CommentedConfigurationNode)this.loader.load();
            if (this.root == null) {
                this.logger.severe("[QC] Failed to load configuration " + this.filename + ", root configuration is null");
                Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
            }
        }
        catch (ConfigurateException e) {
            this.logger.severe("[QC] Could not load configuration " + this.filename + ": Invalid Syntax");
            throw new RuntimeException(e);
        }
        if (this.silentTestRequirements()) {
            this.logger.info("[QC] Successfully loaded configuration file " + this.filename + " on root path " + this.path);
        } else {
            this.logger.warning("[QC] Loaded configuration file " + this.filename + " on root path " + this.path + " with missing options, updating file automatically...");
        }
    }

    @Override
    public void save() {
        try {
            this.loader.save((ConfigurationNode)this.root);
        }
        catch (ConfigurateException e) {
            this.logger.severe("[QC] Unable to save configuration file " + this.filename + ":\n" + e.getMessage());
        }
    }

    @Deprecated
    public CommentedConfigurationNode getRootConfigurationNode() {
        return this.root;
    }

    @Override
    public ConfigurationNode get(String path) throws InvalidNodeException {
        ScopedConfigurationNode node = this.root.node((Object[])path.split("\\."));
        if (node.isNull()) {
            throw new InvalidNodeException("[QC] Node " + path + " in configuration " + this.path + " does not exist!");
        }
        return node;
    }

    public boolean getBoolean(String path) throws InvalidNodeException {
        return this.get(path).getBoolean();
    }

    @Nullable
    public int getInt(String path) throws InvalidNodeException {
        return this.get(path).getInt();
    }

    @Nullable
    public double getDouble(String path) throws InvalidNodeException {
        return this.get(path).getDouble();
    }

    @Nullable
    public String getString(String path) throws InvalidNodeException {
        return this.get(path).getString();
    }

    @Nullable
    public <E> List<E> getList(String path, Class<E> type) throws InvalidNodeException, SerializationException {
        try {
            return this.get(path).getList(type);
        }
        catch (SerializationException e) {
            throw new SerializationException("Unmatching data types found while serializing node " + path);
        }
    }

    @Nullable
    public Boolean getFinalBoolean(String path) {
        try {
            return this.getBoolean(path);
        }
        catch (InvalidNodeException e) {
            this.logger.severe("[QC] InvalidNodeException: Request for non-existent node: " + path);
            return null;
        }
    }

    @Nullable
    public Integer getFinalInt(String path) {
        try {
            return this.getInt(path);
        }
        catch (InvalidNodeException e) {
            this.logger.severe("[QC] InvalidNodeException: Request for non-existent node: " + path);
            return null;
        }
    }

    @Nullable
    public Double getFinalDouble(String path) {
        try {
            return this.getDouble(path);
        }
        catch (InvalidNodeException e) {
            this.logger.severe("[QC] InvalidNodeException: Request for non-existent node: " + path);
            return null;
        }
    }

    @Nullable
    public String getFinalString(String path) {
        try {
            return this.getString(path);
        }
        catch (InvalidNodeException e) {
            this.logger.severe("[QC] InvalidNodeException: Request for non-existent node: " + path);
            return null;
        }
    }

    @Nullable
    public String getFinalStringSilent(String path) {
        try {
            return this.getString(path);
        }
        catch (InvalidNodeException ignored) {
            return null;
        }
    }

    @Nullable
    public <E> List<E> getFinalList(String path, Class<E> type) {
        try {
            return this.get(path).getList(type);
        }
        catch (SerializationException e) {
            this.logger.severe("[QC] SerializationException: Unmatching data types found while serializing node " + path);
        }
        catch (InvalidNodeException e) {
            this.logger.severe("[QC] InvalidNodeException: Request for non-existent node: " + path);
        }
        return null;
    }

    public void unset(@NotNull String path) {
        ScopedConfigurationNode node = this.root.node((Object[])path.split("\\."));
        Objects.requireNonNull(node.parent()).removeChild(node.key());
    }

    @Override
    public void set(@NotNull String path, Object value) {
        try {
            ((CommentedConfigurationNode)this.root.node((Object[])path.split("\\."))).set(value.getClass(), value);
        }
        catch (SerializationException e) {
            this.logger.severe("[QC] SerializationException: " + e.getMessage());
        }
    }

    public void set(@NotNull String path, Object value, String comment) {
        try {
            ((CommentedConfigurationNode)this.root.node((Object[])path.split("\\."))).act(n -> {
                n.comment(comment);
                n.set(value);
            });
        }
        catch (SerializationException e) {
            this.logger.severe("[QC] SerializationException: " + e.getMessage());
        }
    }

    @Override
    public boolean has(@NotNull String path) {
        return !((CommentedConfigurationNode)this.root.node((Object[])path.split("\\."))).isNull();
    }

    public String filename() {
        return this.filename + ".conf";
    }

    @Override
    public JavaPlugin getPlugin() {
        return this.plugin;
    }
}

