/*
 * Decompiled with CFR 0.152.
 */
package de.knabbiii.spawnelytra.listener;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.KeybindComponent;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class SpawnBoostListener
extends BukkitRunnable
implements Listener {
    private final Plugin plugin;
    private final int multiplyValue;
    private final int spawnRadius;
    private final boolean boostEnabled;
    private final World world;
    private final List<Player> flying = new ArrayList<Player>();
    private final List<Player> boosted = new ArrayList<Player>();
    private final List<Player> gracePeriod = new ArrayList<Player>();
    private final Map<Player, ItemStack> originalChestplates = new HashMap<Player, ItemStack>();
    private final String message;
    private final Sound boostSound;
    private final String boostDirection;
    private final boolean showBoostMessage;
    private final boolean showActivationMessage;

    public static SpawnBoostListener create(Plugin plugin) {
        Sound sound;
        FileConfiguration config = plugin.getConfig();
        if (!(config.contains("multiplyValue") && config.contains("spawnRadius") && config.contains("boostEnabled") && config.contains("world") && config.contains("message"))) {
            plugin.saveResource("config.yml", true);
            plugin.reloadConfig();
        }
        String soundName = config.getString("boostSound", "ENTITY_BAT_TAKEOFF");
        try {
            sound = Sound.valueOf((String)soundName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            plugin.getLogger().warning("Invalid sound: " + soundName + ". Using default sound.");
            sound = Sound.ENTITY_BAT_TAKEOFF;
        }
        return new SpawnBoostListener(plugin, config.getInt("multiplyValue"), config.getInt("spawnRadius"), config.getBoolean("boostEnabled"), Objects.requireNonNull(Bukkit.getWorld((String)config.getString("world")), "Invalid world " + config.getString("world")), config.getString("message"), sound, config.getString("boostDirection", "forward"), config.getBoolean("showBoostMessage", true), config.getBoolean("showActivationMessage", true));
    }

    private SpawnBoostListener(Plugin plugin, int multiplyValue, int spawnRadius, boolean boostEnabled, World world, String message, Sound boostSound, String boostDirection, boolean showBoostMessage, boolean showActivationMessage) {
        this.plugin = plugin;
        this.multiplyValue = multiplyValue;
        this.spawnRadius = spawnRadius;
        this.boostEnabled = boostEnabled;
        this.world = world;
        this.message = message;
        this.boostSound = boostSound;
        this.boostDirection = boostDirection.toLowerCase();
        this.showBoostMessage = showBoostMessage;
        this.showActivationMessage = showActivationMessage;
        this.runTaskTimer(this.plugin, 0L, 5L);
    }

    public void run() {
        Bukkit.getOnlinePlayers().forEach(player -> {
            if (player.getGameMode() != GameMode.SURVIVAL && player.getGameMode() != GameMode.ADVENTURE) {
                return;
            }
            boolean inSpawnRadius = this.isInSpawnRadius((Player)player);
            boolean isCurrentlyFlying = this.flying.contains(player);
            boolean isBedrock = this.isBedrockPlayer((Player)player);
            if (isCurrentlyFlying) {
                if (isBedrock) {
                    if (!player.isGliding()) {
                        player.setGliding(true);
                    }
                    player.setAllowFlight(true);
                } else {
                    if (!player.isGliding()) {
                        player.setGliding(true);
                    }
                    player.setAllowFlight(false);
                }
            } else {
                player.setAllowFlight(inSpawnRadius);
            }
        });
    }

    @EventHandler
    public void onDoubleJump(PlayerToggleFlightEvent event) {
        ItemStack currentChestplate;
        Player player = event.getPlayer();
        if (player.getGameMode() != GameMode.SURVIVAL && player.getGameMode() != GameMode.ADVENTURE) {
            return;
        }
        if (!this.isInSpawnRadius(player)) {
            return;
        }
        if (this.flying.contains(player)) {
            event.setCancelled(true);
            return;
        }
        event.setCancelled(true);
        boolean isBedrock = this.isBedrockPlayer(player);
        if (isBedrock && ((currentChestplate = player.getInventory().getChestplate()) == null || currentChestplate.getType() != Material.ELYTRA)) {
            this.originalChestplates.put(player, currentChestplate);
            ItemStack virtualElytra = new ItemStack(Material.ELYTRA);
            ItemMeta meta = virtualElytra.getItemMeta();
            if (meta != null) {
                meta.setUnbreakable(true);
                meta.setDisplayName("\u00a77Spawn Elytra");
                virtualElytra.setItemMeta(meta);
            }
            player.getInventory().setChestplate(virtualElytra);
        }
        this.flying.add(player);
        this.gracePeriod.add(player);
        if (isBedrock) {
            player.setAllowFlight(true);
            player.setGliding(true);
        } else {
            player.setGliding(true);
            player.setAllowFlight(false);
        }
        Bukkit.getScheduler().runTaskLater(this.plugin, () -> this.gracePeriod.remove(player), 5L);
        if (this.showActivationMessage && this.boostEnabled) {
            if (isBedrock) {
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, new ComponentBuilder("\u00a7aPress SNEAK to boost yourself!").create());
            } else {
                String[] messageParts = this.message.split("%key%");
                try {
                    BaseComponent[] components = new ComponentBuilder(messageParts[0]).append((BaseComponent)new KeybindComponent("key.swapOffhand")).append(messageParts[1]).create();
                    player.spigot().sendMessage(ChatMessageType.ACTION_BAR, components);
                }
                catch (NoClassDefFoundError | NoSuchMethodError e) {
                    player.sendMessage(this.message.replace("%key%", "[F]"));
                }
            }
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        if (event.getEntityType() == EntityType.PLAYER && (event.getCause() == EntityDamageEvent.DamageCause.FALL || event.getCause() == EntityDamageEvent.DamageCause.FLY_INTO_WALL) && this.flying.contains(event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onSwapItem(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("spawnelytra.useboost")) {
            return;
        }
        if (this.isBedrockPlayer(player)) {
            return;
        }
        if (!this.boostEnabled || !this.flying.contains(player) || this.boosted.contains(player)) {
            return;
        }
        event.setCancelled(true);
        this.applyBoost(player);
    }

    @EventHandler
    public void onSneak(PlayerToggleSneakEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("spawnelytra.useboost")) {
            return;
        }
        if (!this.isBedrockPlayer(player)) {
            return;
        }
        if (!event.isSneaking()) {
            return;
        }
        if (!this.boostEnabled || !this.flying.contains(player) || this.boosted.contains(player)) {
            return;
        }
        this.applyBoost(player);
    }

    private void applyBoost(Player player) {
        this.boosted.add(player);
        Vector velocity = "upward".equalsIgnoreCase(this.boostDirection) ? new Vector(0, this.multiplyValue, 0) : player.getLocation().getDirection().multiply(this.multiplyValue);
        player.setVelocity(velocity);
        player.playSound(player.getLocation(), this.boostSound, 1.0f, 1.0f);
        if (this.showBoostMessage) {
            try {
                BaseComponent[] components = new ComponentBuilder("\u00a7aBoost activated!").create();
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, components);
            }
            catch (NoClassDefFoundError | NoSuchMethodError e) {
                player.sendMessage("\u00a7aBoost activated!");
            }
        }
    }

    @EventHandler
    public void onToggleGlide(EntityToggleGlideEvent event) {
        if (event.getEntityType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (this.flying.contains(player)) {
            boolean isBedrock = this.isBedrockPlayer(player);
            if (!event.isGliding() && isBedrock) {
                if (!this.gracePeriod.contains(player) && !player.getLocation().getBlock().getRelative(BlockFace.DOWN).getType().isAir()) {
                    player.setAllowFlight(false);
                    player.setGliding(false);
                    this.boosted.remove(player);
                    if (isBedrock && this.originalChestplates.containsKey(player)) {
                        player.getInventory().setChestplate(this.originalChestplates.remove(player));
                    }
                    Bukkit.getScheduler().runTaskLater(this.plugin, () -> this.flying.remove(player), 5L);
                } else {
                    event.setCancelled(true);
                }
            } else if (!isBedrock) {
                event.setCancelled(true);
                if (!this.gracePeriod.contains(player) && !player.getLocation().getBlock().getRelative(BlockFace.DOWN).getType().isAir()) {
                    player.setAllowFlight(false);
                    player.setGliding(false);
                    this.boosted.remove(player);
                    if (this.originalChestplates.containsKey(player)) {
                        player.getInventory().setChestplate(this.originalChestplates.remove(player));
                    }
                    Bukkit.getScheduler().runTaskLater(this.plugin, () -> this.flying.remove(player), 5L);
                }
            }
        }
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        if (this.flying.contains(player)) {
            player.setAllowFlight(false);
            player.setGliding(false);
            this.flying.remove(player);
            this.boosted.remove(player);
            if (this.originalChestplates.containsKey(player)) {
                player.getInventory().setChestplate(this.originalChestplates.remove(player));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClick(InventoryClickEvent event) {
        ItemMeta meta;
        ItemStack clicked;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (this.flying.contains(player) && this.isBedrockPlayer(player) && event.getSlotType() == InventoryType.SlotType.ARMOR && event.getSlot() == 38 && (clicked = event.getCurrentItem()) != null && clicked.getType() == Material.ELYTRA && (meta = clicked.getItemMeta()) != null && "\u00a77Spawn Elytra".equals(meta.getDisplayName())) {
            event.setCancelled(true);
            player.sendMessage("\u00a7cYou can't remove the elytra while flying!");
        }
    }

    private boolean isInSpawnRadius(Player player) {
        if (!player.getWorld().equals((Object)this.world)) {
            return false;
        }
        return player.getWorld().getSpawnLocation().distance(player.getLocation()) <= (double)this.spawnRadius;
    }

    private boolean isBedrockPlayer(Player player) {
        try {
            Class<?> floodgateApi = Class.forName("org.geysermc.floodgate.api.FloodgateApi");
            Object api = floodgateApi.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            return (Boolean)floodgateApi.getMethod("isFloodgatePlayer", UUID.class).invoke(api, player.getUniqueId());
        }
        catch (Exception floodgateApi) {
            String uuid = player.getUniqueId().toString();
            return uuid.startsWith("00000000-0000-0000");
        }
    }
}

