/*
 * Decompiled with CFR 0.152.
 */
package de.knabbiii.spawnelytra;

import de.knabbiii.spawnelytra.commands.SpawnElytraCommand;
import de.knabbiii.spawnelytra.listener.SpawnBoostListener;
import de.knabbiii.spawnelytra.metrics.bukkit.Metrics;
import java.util.Objects;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SpawnElytra
extends JavaPlugin {
    private static SpawnElytra instance;
    private SpawnBoostListener listener;

    public static SpawnElytra getInstance() {
        return instance;
    }

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        if (this.getConfig().getBoolean("enableMetrics", true)) {
            new Metrics(this, 28033);
        }
        this.listener = SpawnBoostListener.create((Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.listener, (Plugin)this);
        SpawnElytraCommand commandHandler = new SpawnElytraCommand();
        Objects.requireNonNull(this.getCommand("spawnelytra")).setExecutor((CommandExecutor)commandHandler);
        Objects.requireNonNull(this.getCommand("spawnelytra")).setTabCompleter((TabCompleter)commandHandler);
        this.getLogger().info("SpawnElytra v" + this.getDescription().getVersion() + " enabled!");
    }

    public void onDisable() {
        if (this.listener != null) {
            this.listener.cancel();
        }
        instance = null;
        this.getLogger().info("SpawnElytra v" + this.getDescription().getVersion() + " disabled!");
    }

    public void reloadConfig() {
        super.reloadConfig();
        if (this.listener != null) {
            this.listener.cancel();
        }
        this.listener = SpawnBoostListener.create((Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.listener, (Plugin)this);
        this.getLogger().info("SpawnElytra configuration reloaded!");
    }
}

