/*
 * Decompiled with CFR 0.152.
 */
package de.knabbiii.spawnelytra.listener;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.KeybindComponent;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class SpawnBoostListener
extends BukkitRunnable
implements Listener {
    private final Plugin plugin;
    private final int multiplyValue;
    private final int spawnRadius;
    private final boolean boostEnabled;
    private final World world;
    private final List<Player> flying = new ArrayList<Player>();
    private final List<Player> boosted = new ArrayList<Player>();
    private final String message;
    private final Sound boostSound;
    private final String boostDirection;
    private final boolean showBoostMessage;
    private final boolean showActivationMessage;

    public static SpawnBoostListener create(Plugin plugin) {
        Sound sound;
        FileConfiguration config = plugin.getConfig();
        if (!(config.contains("multiplyValue") && config.contains("spawnRadius") && config.contains("boostEnabled") && config.contains("world") && config.contains("message"))) {
            plugin.saveResource("config.yml", true);
            plugin.reloadConfig();
        }
        String soundName = config.getString("boostSound", "ENTITY_BAT_TAKEOFF");
        try {
            sound = Sound.valueOf((String)soundName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            plugin.getLogger().warning("Invalid sound: " + soundName + ". Using default sound.");
            sound = Sound.ENTITY_BAT_TAKEOFF;
        }
        return new SpawnBoostListener(plugin, config.getInt("multiplyValue"), config.getInt("spawnRadius"), config.getBoolean("boostEnabled"), Objects.requireNonNull(Bukkit.getWorld((String)config.getString("world")), "Invalid world " + config.getString("world")), config.getString("message"), sound, config.getString("boostDirection", "forward"), config.getBoolean("showBoostMessage", true), config.getBoolean("showActivationMessage", true));
    }

    private SpawnBoostListener(Plugin plugin, int multiplyValue, int spawnRadius, boolean boostEnabled, World world, String message, Sound boostSound, String boostDirection, boolean showBoostMessage, boolean showActivationMessage) {
        this.plugin = plugin;
        this.multiplyValue = multiplyValue;
        this.spawnRadius = spawnRadius;
        this.boostEnabled = boostEnabled;
        this.world = world;
        this.message = message;
        this.boostSound = boostSound;
        this.boostDirection = boostDirection.toLowerCase();
        this.showBoostMessage = showBoostMessage;
        this.showActivationMessage = showActivationMessage;
        this.runTaskTimer(this.plugin, 0L, 3L);
    }

    public void run() {
        Bukkit.getOnlinePlayers().forEach(player -> {
            if (player.getGameMode() != GameMode.SURVIVAL && player.getGameMode() != GameMode.ADVENTURE) {
                return;
            }
            boolean inSpawnRadius = this.isInSpawnRadius((Player)player);
            boolean isCurrentlyFlying = this.flying.contains(player);
            if (isCurrentlyFlying) {
                player.setAllowFlight(false);
            } else {
                player.setAllowFlight(inSpawnRadius);
            }
            if (isCurrentlyFlying && !player.getLocation().getBlock().getRelative(BlockFace.DOWN).getType().isAir()) {
                player.setAllowFlight(false);
                player.setGliding(false);
                this.boosted.remove(player);
                Bukkit.getScheduler().runTaskLater(this.plugin, () -> this.flying.remove(player), 5L);
            }
        });
    }

    @EventHandler
    public void onDoubleJump(PlayerToggleFlightEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("spawnelytra.use")) {
            return;
        }
        if (player.getGameMode() != GameMode.SURVIVAL && player.getGameMode() != GameMode.ADVENTURE) {
            return;
        }
        if (!this.isInSpawnRadius(player)) {
            return;
        }
        if (this.flying.contains(player)) {
            event.setCancelled(true);
            return;
        }
        event.setCancelled(true);
        player.setGliding(true);
        this.flying.add(player);
        if (this.showActivationMessage && this.boostEnabled) {
            String[] messageParts = this.message.split("%key%");
            try {
                BaseComponent[] components = new ComponentBuilder(messageParts[0]).append((BaseComponent)new KeybindComponent("key.swapOffhand")).append(messageParts[1]).create();
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, components);
            }
            catch (Exception e) {
                player.sendMessage(this.message.replace("%key%", "[F]"));
            }
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        if (event.getEntityType() == EntityType.PLAYER && (event.getCause() == EntityDamageEvent.DamageCause.FALL || event.getCause() == EntityDamageEvent.DamageCause.FLY_INTO_WALL) && this.flying.contains(event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onSwapItem(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("spawnelytra.useboost")) {
            return;
        }
        if (!this.boostEnabled || !this.flying.contains(player) || this.boosted.contains(player)) {
            return;
        }
        event.setCancelled(true);
        this.boosted.add(player);
        Vector velocity = "upward".equalsIgnoreCase(this.boostDirection) ? new Vector(0, this.multiplyValue, 0) : player.getLocation().getDirection().multiply(this.multiplyValue);
        player.setVelocity(velocity);
        player.playSound(player.getLocation(), this.boostSound, 1.0f, 1.0f);
        if (this.showBoostMessage) {
            try {
                BaseComponent[] components = new ComponentBuilder("\u00a7aBoost activated!").create();
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, components);
            }
            catch (Exception e) {
                player.sendMessage("\u00a7aBoost activated!");
            }
        }
    }

    @EventHandler
    public void onToggleGlide(EntityToggleGlideEvent event) {
        if (event.getEntityType() == EntityType.PLAYER && this.flying.contains(event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        if (this.flying.contains(player)) {
            player.setAllowFlight(false);
            player.setGliding(false);
            this.flying.remove(player);
            this.boosted.remove(player);
        }
    }

    private boolean isInSpawnRadius(Player player) {
        if (!player.getWorld().equals(this.world)) {
            return false;
        }
        return player.getWorld().getSpawnLocation().distance(player.getLocation()) <= (double)this.spawnRadius;
    }
}

