/*
 * Decompiled with CFR 0.152.
 */
package de.knabbiii.spawnelytra.commands;

import de.knabbiii.spawnelytra.SpawnElytra;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class SpawnElytraCommand
implements CommandExecutor,
TabCompleter {
    private final SpawnElytra plugin;

    public SpawnElytraCommand(SpawnElytra plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.sendHelpMessage(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                if (!sender.hasPermission("spawnelytra.admin")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                    return true;
                }
                this.plugin.reloadConfig();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "SpawnElytra configuration reloaded successfully!");
                return true;
            }
            case "info": {
                this.sendInfoMessage(sender);
                return true;
            }
        }
        this.sendHelpMessage(sender);
        return true;
    }

    private void sendHelpMessage(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "=== SpawnElytra Commands ===");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/spawnelytra info " + String.valueOf(ChatColor.WHITE) + "- Show plugin information");
        if (sender.hasPermission("spawnelytra.admin")) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/spawnelytra reload " + String.valueOf(ChatColor.WHITE) + "- Reload plugin configuration");
        }
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Plugin by Knabbiii - Enhanced with ideas from blax-k");
    }

    private void sendInfoMessage(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "=== SpawnElytra Info ===");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Version: " + String.valueOf(ChatColor.WHITE) + this.plugin.getDescription().getVersion());
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Author: " + String.valueOf(ChatColor.WHITE) + (String)this.plugin.getDescription().getAuthors().get(0));
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Website: " + String.valueOf(ChatColor.WHITE) + this.plugin.getDescription().getWebsite());
        sender.sendMessage("");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "World: " + String.valueOf(ChatColor.WHITE) + this.plugin.getConfig().getString("world"));
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Spawn Radius: " + String.valueOf(ChatColor.WHITE) + this.plugin.getConfig().getInt("spawnRadius"));
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Boost Multiplier: " + String.valueOf(ChatColor.WHITE) + this.plugin.getConfig().getInt("multiplyValue"));
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Boost Enabled: " + String.valueOf(ChatColor.WHITE) + this.plugin.getConfig().getBoolean("boostEnabled"));
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Boost Sound: " + String.valueOf(ChatColor.WHITE) + this.plugin.getConfig().getString("boostSound"));
        sender.sendMessage("");
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Enhanced with features inspired by blax-k's implementation");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>(Arrays.asList("info"));
            if (sender.hasPermission("spawnelytra.admin")) {
                completions.add("reload");
            }
            return completions.stream().filter(c -> c.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

