/*
 * Decompiled with CFR 0.152.
 */
package dev.knabbiii.gentlefeet;

import dev.knabbiii.gentlefeet.Config;
import dev.knabbiii.gentlefeet.GentleFeet;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class GentleFeetCommand
implements CommandExecutor,
TabCompleter {
    private final GentleFeet plugin;

    public GentleFeetCommand(GentleFeet plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!command.getName().equalsIgnoreCase("gentlefeet")) {
            return false;
        }
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "reload": {
                return this.handleReload(sender);
            }
            case "set": {
                return this.handleSet(sender, args);
            }
            case "toggle": {
                return this.handleToggle(sender, args);
            }
            case "info": {
                return this.handleInfo(sender);
            }
            case "help": {
                this.sendHelp(sender);
                return true;
            }
        }
        sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown command. Use /gentlefeet help for available commands.");
        return true;
    }

    private boolean handleReload(CommandSender sender) {
        if (!sender.hasPermission("gentlefeet.admin")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to reload the plugin.");
            return true;
        }
        this.plugin.reloadPluginConfig();
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "GentleFeet configuration reloaded successfully!");
        return true;
    }

    private boolean handleSet(CommandSender sender, String[] args) {
        if (!sender.hasPermission("gentlefeet.admin")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to modify settings.");
            return true;
        }
        if (args.length < 3) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /gentlefeet set <setting> <value>");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Available settings: featherfall-chance, max-level");
            return true;
        }
        String setting = args[1].toLowerCase();
        String value = args[2];
        switch (setting) {
            case "featherfall-chance": 
            case "chance": {
                return this.setFeatherFallChance(sender, value);
            }
            case "max-level": 
            case "maxlevel": {
                return this.setMaxLevel(sender, value);
            }
        }
        sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown setting: " + setting);
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Available settings: featherfall-chance, max-level");
        return true;
    }

    private boolean handleToggle(CommandSender sender, String[] args) {
        String setting;
        if (!sender.hasPermission("gentlefeet.admin")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to modify settings.");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /gentlefeet toggle <setting>");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Available settings: barefoot, featherfall, notify-players, debug, metrics");
            return true;
        }
        switch (setting = args[1].toLowerCase()) {
            case "barefoot": {
                return this.toggleBarefootProtection(sender);
            }
            case "featherfall": 
            case "feather-fall": {
                return this.toggleFeatherFall(sender);
            }
            case "notify-players": 
            case "notify": {
                return this.toggleNotifyPlayers(sender);
            }
            case "debug": {
                return this.toggleDebug(sender);
            }
            case "metrics": {
                return this.toggleMetrics(sender);
            }
        }
        sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown setting: " + setting);
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Available settings: barefoot, featherfall, notify-players, debug, metrics");
        return true;
    }

    private boolean handleInfo(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "=== GentleFeet Configuration ===");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Barefoot Protection: " + (Config.enableBarefootProtection ? String.valueOf(ChatColor.GREEN) + "Enabled" : String.valueOf(ChatColor.RED) + "Disabled"));
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Feather Falling: " + (Config.enableFeatherFalling ? String.valueOf(ChatColor.GREEN) + "Enabled" : String.valueOf(ChatColor.RED) + "Disabled"));
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Feather Fall Chance: " + String.valueOf(ChatColor.WHITE) + Config.featherFallingChancePerLevel + "% per level");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Max Feather Fall Level: " + String.valueOf(ChatColor.WHITE) + Config.maxFeatherFallingLevel);
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Notify Players: " + (Config.notifyPlayers ? String.valueOf(ChatColor.GREEN) + "Enabled" : String.valueOf(ChatColor.RED) + "Disabled"));
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Debug Mode: " + (Config.debugMode ? String.valueOf(ChatColor.GREEN) + "Enabled" : String.valueOf(ChatColor.RED) + "Disabled"));
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Metrics Collection: " + (Config.enableMetrics ? String.valueOf(ChatColor.GREEN) + "Enabled" : String.valueOf(ChatColor.RED) + "Disabled"));
        return true;
    }

    private boolean setFeatherFallChance(CommandSender sender, String value) {
        try {
            int chance = Integer.parseInt(value);
            if (chance < 1 || chance > 100) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Feather fall chance must be between 1 and 100.");
                return true;
            }
            Config.featherFallingChancePerLevel = chance;
            this.plugin.getConfig().set("feather-falling.chance-per-level", (Object)chance);
            this.plugin.saveConfig();
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Feather fall chance set to " + chance + "% per level.");
            return true;
        }
        catch (NumberFormatException e) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid number: " + value);
            return true;
        }
    }

    private boolean setMaxLevel(CommandSender sender, String value) {
        try {
            int level = Integer.parseInt(value);
            if (level < 1 || level > 10) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Max level must be between 1 and 10.");
                return true;
            }
            Config.maxFeatherFallingLevel = level;
            this.plugin.getConfig().set("feather-falling.max-level", (Object)level);
            this.plugin.saveConfig();
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Max feather fall level set to " + level + ".");
            return true;
        }
        catch (NumberFormatException e) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid number: " + value);
            return true;
        }
    }

    private boolean toggleBarefootProtection(CommandSender sender) {
        Config.enableBarefootProtection = !Config.enableBarefootProtection;
        this.plugin.getConfig().set("barefoot.enable", (Object)Config.enableBarefootProtection);
        this.plugin.saveConfig();
        String status = Config.enableBarefootProtection ? String.valueOf(ChatColor.GREEN) + "enabled" : String.valueOf(ChatColor.RED) + "disabled";
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Barefoot protection " + status + String.valueOf(ChatColor.YELLOW) + ".");
        return true;
    }

    private boolean toggleFeatherFall(CommandSender sender) {
        Config.enableFeatherFalling = !Config.enableFeatherFalling;
        this.plugin.getConfig().set("feather-falling.enable", (Object)Config.enableFeatherFalling);
        this.plugin.saveConfig();
        String status = Config.enableFeatherFalling ? String.valueOf(ChatColor.GREEN) + "enabled" : String.valueOf(ChatColor.RED) + "disabled";
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Feather falling protection " + status + String.valueOf(ChatColor.YELLOW) + ".");
        return true;
    }

    private boolean toggleNotifyPlayers(CommandSender sender) {
        Config.notifyPlayers = !Config.notifyPlayers;
        this.plugin.getConfig().set("debug.notify-players", (Object)Config.notifyPlayers);
        this.plugin.saveConfig();
        String status = Config.notifyPlayers ? String.valueOf(ChatColor.GREEN) + "enabled" : String.valueOf(ChatColor.RED) + "disabled";
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Player notifications " + status + String.valueOf(ChatColor.YELLOW) + ".");
        return true;
    }

    private boolean toggleDebug(CommandSender sender) {
        Config.debugMode = !Config.debugMode;
        this.plugin.getConfig().set("debug.enable", (Object)Config.debugMode);
        this.plugin.saveConfig();
        String status = Config.debugMode ? String.valueOf(ChatColor.GREEN) + "enabled" : String.valueOf(ChatColor.RED) + "disabled";
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Debug mode " + status + String.valueOf(ChatColor.YELLOW) + ".");
        return true;
    }

    private boolean toggleMetrics(CommandSender sender) {
        Config.enableMetrics = !Config.enableMetrics;
        this.plugin.getConfig().set("metrics.enable", (Object)Config.enableMetrics);
        this.plugin.saveConfig();
        String status = Config.enableMetrics ? String.valueOf(ChatColor.GREEN) + "enabled" : String.valueOf(ChatColor.RED) + "disabled";
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Metrics collection " + status + String.valueOf(ChatColor.YELLOW) + ".");
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Note: Restart required for this change to take effect.");
        return true;
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "=== GentleFeet Commands ===");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/gentlefeet info " + String.valueOf(ChatColor.WHITE) + "- Show current configuration");
        if (sender.hasPermission("gentlefeet.admin")) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/gentlefeet reload " + String.valueOf(ChatColor.WHITE) + "- Reload configuration");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/gentlefeet toggle <setting> " + String.valueOf(ChatColor.WHITE) + "- Toggle a setting");
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "  Settings: barefoot, featherfall, notify-players, debug, metrics");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/gentlefeet set <setting> <value> " + String.valueOf(ChatColor.WHITE) + "- Set a value");
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "  Settings: featherfall-chance (1-100), max-level (1-10)");
        }
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Prevents your tootsies trampling crops!");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            List<String> subCommands = Arrays.asList("info", "help");
            if (sender.hasPermission("gentlefeet.admin")) {
                subCommands = Arrays.asList("reload", "set", "toggle", "info", "help");
            }
            return subCommands.stream().filter(cmd -> cmd.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 && sender.hasPermission("gentlefeet.admin")) {
            if (args[0].equalsIgnoreCase("toggle")) {
                return Arrays.asList("barefoot", "featherfall", "notify-players", "debug", "metrics").stream().filter(cmd -> cmd.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
            if (args[0].equalsIgnoreCase("set")) {
                return Arrays.asList("featherfall-chance", "max-level").stream().filter(cmd -> cmd.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
        }
        if (args.length == 3 && sender.hasPermission("gentlefeet.admin") && args[0].equalsIgnoreCase("set")) {
            if (args[1].equalsIgnoreCase("featherfall-chance")) {
                return Arrays.asList("25", "50", "75", "100");
            }
            if (args[1].equalsIgnoreCase("max-level")) {
                return Arrays.asList("1", "2", "3", "4", "5");
            }
        }
        return null;
    }
}

