/*
 * Decompiled with CFR 0.152.
 */
package dev.knabbiii.gentlefeet;

import dev.knabbiii.gentlefeet.Config;
import dev.knabbiii.gentlefeet.GentleFeetCommand;
import dev.knabbiii.gentlefeet.Metrics;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class GentleFeet
extends JavaPlugin
implements Listener {
    private static GentleFeet instance;
    private Random random;

    public void onEnable() {
        instance = this;
        this.random = new Random();
        this.saveDefaultConfig();
        this.loadConfigValues();
        if (Config.enableMetrics) {
            new Metrics(this, 27864);
        }
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        GentleFeetCommand commandHandler = new GentleFeetCommand(this);
        this.getCommand("gentlefeet").setExecutor((CommandExecutor)commandHandler);
        this.getCommand("gentlefeet").setTabCompleter((TabCompleter)commandHandler);
        this.getServer().getConsoleSender().sendMessage(String.valueOf(ChatColor.WHITE) + "[" + String.valueOf(ChatColor.GOLD) + "GentleFeet" + String.valueOf(ChatColor.WHITE) + "] " + String.valueOf(ChatColor.GREEN) + "enabled v" + this.getDescription().getVersion());
        if (Config.debugMode) {
            this.getLogger().info("Debug mode enabled");
            this.getLogger().info("Barefoot protection: " + Config.enableBarefootProtection);
            this.getLogger().info("Feather falling protection: " + Config.enableFeatherFalling);
            this.getLogger().info("Feather falling chance per level: " + Config.featherFallingChancePerLevel + "%");
        }
    }

    public void onDisable() {
        this.getServer().getConsoleSender().sendMessage(String.valueOf(ChatColor.WHITE) + "[" + String.valueOf(ChatColor.GOLD) + "GentleFeet" + String.valueOf(ChatColor.WHITE) + "] " + String.valueOf(ChatColor.RED) + "disabled");
    }

    public void reloadPluginConfig() {
        this.loadConfigValues();
        this.getLogger().info("Configuration reloaded");
    }

    private void loadConfigValues() {
        this.reloadConfig();
        Config.usePermissions = this.getConfig().getBoolean("permissions.use-permissions", true);
        Config.useFeatherFallPermissions = this.getConfig().getBoolean("permissions.use-featherfall-permissions", true);
        Config.enableFeatherFalling = this.getConfig().getBoolean("feather-falling.enable", true);
        Config.featherFallingChancePerLevel = Math.max(1, Math.min(100, this.getConfig().getInt("feather-falling.chance-per-level", 25)));
        Config.maxFeatherFallingLevel = Math.max(1, this.getConfig().getInt("feather-falling.max-level", 4));
        Config.enableBarefootProtection = this.getConfig().getBoolean("barefoot.enable", true);
        Config.debugMode = this.getConfig().getBoolean("debug.enable", false);
        Config.notifyPlayers = this.getConfig().getBoolean("debug.notify-players", false);
        Config.enableMetrics = this.getConfig().getBoolean("metrics.enable", true);
        Config.barefootProtectionMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.barefoot-protection", "&7Your gentle steps protected the crops!"));
        Config.featherFallProtectionMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.featherfall-protection", "&7Your feather falling boots (Level {level}) protected the crops!"));
    }

    @EventHandler
    public void onPlayerTramplingCrops(PlayerInteractEvent event) {
        ItemStack boots;
        boolean hasBoots;
        if (event.getAction() != Action.PHYSICAL) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        if (block == null || block.getType() != Material.FARMLAND) {
            return;
        }
        if (Config.debugMode) {
            this.getLogger().info("Player " + player.getName() + " stepped on farmland at " + block.getLocation().toString());
        }
        boolean bl = hasBoots = (boots = player.getInventory().getBoots()) != null && boots.getType() != Material.AIR;
        if (!hasBoots && Config.enableBarefootProtection && this.handleBarefootProtection(player, event)) {
            return;
        }
        if (hasBoots && Config.enableFeatherFalling) {
            this.handleFeatherFallingProtection(player, boots, event);
        }
    }

    private boolean handleBarefootProtection(Player player, PlayerInteractEvent event) {
        if (Config.usePermissions && !player.hasPermission("gentlefeet.use")) {
            if (Config.debugMode) {
                this.getLogger().info("Player " + player.getName() + " lacks gentlefeet.use permission");
            }
            return false;
        }
        event.setCancelled(true);
        if (Config.debugMode) {
            this.getLogger().info("Barefoot protection activated for " + player.getName());
        }
        if (Config.notifyPlayers && !Config.barefootProtectionMessage.isEmpty()) {
            player.sendMessage(Config.barefootProtectionMessage);
        }
        return true;
    }

    private void handleFeatherFallingProtection(Player player, ItemStack boots, PlayerInteractEvent event) {
        boolean isProtected;
        if (Config.useFeatherFallPermissions && !player.hasPermission("gentlefeet.featherfall")) {
            if (Config.debugMode) {
                this.getLogger().info("Player " + player.getName() + " lacks gentlefeet.featherfall permission");
            }
            return;
        }
        int featherFallLevel = boots.getEnchantmentLevel(Enchantment.FEATHER_FALLING);
        if (featherFallLevel <= 0) {
            if (Config.debugMode) {
                this.getLogger().info("Player " + player.getName() + " has boots but no feather falling enchantment");
            }
            return;
        }
        int effectiveLevel = Math.min(featherFallLevel, Config.maxFeatherFallingLevel);
        int protectionChance = effectiveLevel * Config.featherFallingChancePerLevel;
        protectionChance = Math.min(100, protectionChance);
        boolean bl = isProtected = this.random.nextInt(100) < protectionChance;
        if (Config.debugMode) {
            this.getLogger().info("Player " + player.getName() + " feather falling level: " + featherFallLevel + " (effective: " + effectiveLevel + "), protection chance: " + protectionChance + "%, protected: " + isProtected);
        }
        if (isProtected) {
            event.setCancelled(true);
            if (Config.notifyPlayers && !Config.featherFallProtectionMessage.isEmpty()) {
                String message = Config.featherFallProtectionMessage.replace("{level}", String.valueOf(featherFallLevel));
                player.sendMessage(message);
            }
        }
    }

    public static GentleFeet getInstance() {
        return instance;
    }
}

