/*
 * Decompiled with CFR 0.152.
 */
package dev.knabbiii.feathertouch;

import dev.knabbiii.feathertouch.command.FeatherTouchCommand;
import dev.knabbiii.feathertouch.libs.bstats.Metrics;
import dev.knabbiii.feathertouch.listener.FeatherDamageListener;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class FeatherTouchPlugin
extends JavaPlugin {
    private FeatherDamageListener damageListener;
    private FeatherTouchCommand featherTouchCommand;
    private boolean pluginEnabled = true;
    private boolean soundEnabled = true;

    public void onEnable() {
        this.getLogger().info("FeatherTouch is starting up...");
        this.saveDefaultConfig();
        this.loadConfigSettings();
        this.damageListener = new FeatherDamageListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.damageListener, (Plugin)this);
        this.featherTouchCommand = new FeatherTouchCommand(this);
        this.getCommand("feathertouch").setExecutor((CommandExecutor)this.featherTouchCommand);
        if (this.getConfig().getBoolean("metrics", true)) {
            new Metrics((Plugin)this, 27875);
            this.getLogger().info("Metrics enabled (bStats)");
        }
        this.getLogger().info("FeatherTouch has been enabled!");
    }

    public void onDisable() {
        this.getLogger().info("FeatherTouch has been disabled.");
        this.damageListener = null;
        this.featherTouchCommand = null;
    }

    public void reloadPluginConfig() {
        this.reloadConfig();
        this.loadConfigSettings();
        this.getLogger().info("Configuration reloaded!");
    }

    private void loadConfigSettings() {
        this.pluginEnabled = this.getConfig().getBoolean("settings.enabled", true);
        this.soundEnabled = this.getConfig().getBoolean("settings.sound", true);
    }

    public boolean isPluginEnabled() {
        return this.pluginEnabled;
    }

    public boolean isSoundEnabled() {
        return this.soundEnabled;
    }

    public FeatherDamageListener getDamageListener() {
        return this.damageListener;
    }
}

