/*
 * Decompiled with CFR 0.152.
 */
package es.kikisito.nfcnotes.utils;

import es.kikisito.nfcnotes.Main;
import es.kikisito.nfcnotes.enums.NFCConfig;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class Utils {
    public static boolean depositSuccessful(Main plugin, Player player, double money) {
        switch (plugin.getEco()) {
            case "Vault": {
                Economy vault = plugin.getVaultEco();
                return vault.depositPlayer((OfflinePlayer)player, money).transactionSuccess();
            }
            case "Essentials": 
            case "EssentialsX": {
                try {
                    com.earth2me.essentials.api.Economy.add((UUID)player.getUniqueId(), (BigDecimal)BigDecimal.valueOf(money));
                    return true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return false;
                }
            }
        }
        return false;
    }

    public static boolean withdrawSuccessful(Main plugin, Player player, double money) {
        switch (plugin.getEco()) {
            case "Vault": {
                Economy vault = plugin.getVaultEco();
                return vault.withdrawPlayer((OfflinePlayer)player, money).transactionSuccess();
            }
            case "Essentials": 
            case "EssentialsX": {
                try {
                    com.earth2me.essentials.api.Economy.subtract((UUID)player.getUniqueId(), (BigDecimal)BigDecimal.valueOf(money));
                    return true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return false;
                }
            }
        }
        return false;
    }

    @NotNull
    public static Double getPlayerBalance(Main plugin, Player player) {
        switch (plugin.getEco()) {
            case "Vault": {
                Economy vault = plugin.getVaultEco();
                return vault.getBalance((OfflinePlayer)player);
            }
            case "Essentials": 
            case "EssentialsX": {
                try {
                    return com.earth2me.essentials.api.Economy.getMoneyExact((UUID)player.getUniqueId()).doubleValue();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return 0.0;
    }

    public static boolean isInteger(Object o) {
        boolean isInteger = false;
        try {
            Integer.parseInt(o.toString());
            isInteger = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return isInteger;
    }

    public static DecimalFormat getDecimalFormat() {
        DecimalFormat decimalFormat;
        if (NFCConfig.USE_EUROPEAN_FORMAT.getBoolean()) {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.GERMANY);
            decimalFormatSymbols.setDecimalSeparator(',');
            decimalFormatSymbols.setGroupingSeparator('.');
            decimalFormat = new DecimalFormat(NFCConfig.NOTE_DECIMAL_FORMAT.getString(), decimalFormatSymbols);
        } else {
            decimalFormat = new DecimalFormat(NFCConfig.NOTE_DECIMAL_FORMAT.getString());
        }
        decimalFormat.setMaximumFractionDigits(2);
        return decimalFormat;
    }
}

