/*
 * Decompiled with CFR 0.152.
 */
package es.kikisito.nfcnotes.listeners;

import es.kikisito.nfcnotes.Main;
import es.kikisito.nfcnotes.NFCNote;
import es.kikisito.nfcnotes.commands.Deposit;
import es.kikisito.nfcnotes.enums.ActionMethod;
import es.kikisito.nfcnotes.enums.NFCConfig;
import es.kikisito.nfcnotes.enums.NFCMessages;
import es.kikisito.nfcnotes.events.DepositEvent;
import es.kikisito.nfcnotes.utils.Utils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Map;
import net.kyori.adventure.audience.Audience;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class InteractListener
implements Listener {
    private final Main plugin;

    public InteractListener(Main plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    private void redeem(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        Audience audience = this.plugin.getAdventure().player(p);
        if (NFCNote.isLegacyNFCNote(e.getItem()) && e.getAction().toString().startsWith("RIGHT_CLICK")) {
            this.convertLegacyNote(p, e.getItem());
            return;
        }
        if (NFCNote.isNFCNote(this.plugin, e.getItem()) && e.getAction().toString().startsWith("RIGHT_CLICK")) {
            if (!p.hasPermission("nfcnotes.deposit.action.deposit") || !NFCConfig.MODULES_DEPOSIT_ACTION.getBoolean()) {
                return;
            }
            if (NFCConfig.DISABLED_WORLDS.getStrings().contains(p.getWorld().getName()) && !p.hasPermission("nfcnotes.staff.deposit.bypass.disabled-world")) {
                audience.sendMessage(NFCMessages.DISABLED_WORLD.getString());
                return;
            }
            DecimalFormat decimalFormat = Utils.getDecimalFormat();
            double totalAmount = 0.0;
            if (p.isSneaking() && p.hasPermission("nfcnotes.deposit.massdeposit") && NFCConfig.MODULES_MASSDEPOSIT.getBoolean()) {
                ArrayList<ItemStack> notes = new ArrayList<ItemStack>();
                double value = 0.0;
                for (ItemStack i : e.getPlayer().getInventory()) {
                    if (!NFCNote.isNFCNote(this.plugin, i)) continue;
                    NFCNote nfcNote = new NFCNote(this.plugin, i);
                    double amount = nfcNote.getValue() * (double)i.getAmount();
                    value += amount;
                    notes.add(i);
                }
                depositEvent = new DepositEvent(p, value, ActionMethod.SHIFT_RIGHT_CLICK);
                this.plugin.getServer().getPluginManager().callEvent((Event)depositEvent);
                player = depositEvent.getPlayer();
                playerAudience = this.plugin.getAdventure().player(player);
                money = depositEvent.getMoney();
                formattedMoney = decimalFormat.format(money);
                if (!depositEvent.isCancelled()) {
                    if (Utils.depositSuccessful(this.plugin, player, money)) {
                        for (ItemStack i : notes) {
                            i.setAmount(0);
                        }
                        playerAudience.sendMessage(NFCMessages.MASSDEPOSIT_SUCCESSFUL.getString("{money}", formattedMoney));
                        this.playRedeemSound(player);
                        totalAmount = money;
                    } else {
                        playerAudience.sendMessage(NFCMessages.UNEXPECTED_ERROR.getString());
                    }
                }
            } else {
                NFCNote nfcNote = new NFCNote(this.plugin, e.getItem());
                double m = nfcNote.getValue();
                depositEvent = new DepositEvent(p, m, ActionMethod.RIGHT_CLICK);
                this.plugin.getServer().getPluginManager().callEvent((Event)depositEvent);
                if (!depositEvent.isCancelled()) {
                    player = depositEvent.getPlayer();
                    playerAudience = this.plugin.getAdventure().player(player);
                    money = depositEvent.getMoney();
                    formattedMoney = decimalFormat.format(money);
                    if (Utils.depositSuccessful(this.plugin, player, money)) {
                        playerAudience.sendMessage(NFCMessages.DEPOSIT_SUCCESSFUL.getString("{money}", formattedMoney));
                        this.playRedeemSound(player);
                        e.getItem().setAmount(e.getItem().getAmount() - 1);
                        totalAmount = money;
                    } else {
                        playerAudience.sendMessage(NFCMessages.UNEXPECTED_ERROR.getString());
                    }
                }
            }
            if (totalAmount >= (double)NFCConfig.WARN_VALUE_LIMIT.getInt() && NFCConfig.MODULES_WARN_STAFF.getBoolean()) {
                String formattedMoney = decimalFormat.format(totalAmount);
                for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
                    if (!pl.hasPermission("nfcnotes.staff.warn") || e.getPlayer() == pl) continue;
                    Audience playerAudience = this.plugin.getAdventure().player(pl);
                    playerAudience.sendMessage(NFCMessages.STAFF_WARN_DEPOSIT.getString("{player}", e.getPlayer().getName(), "{money}", formattedMoney));
                    this.plugin.getLogger().info(NFCMessages.STAFF_WARN_DEPOSIT.getLegacyString("{player}", e.getPlayer().getName(), "{money}", formattedMoney));
                }
            }
        }
    }

    private void playRedeemSound(Player player) {
        Deposit.playRedeemSound(player);
    }

    private void convertLegacyNote(Player p, ItemStack note) {
        double money = ((AttributeModifier)note.getItemMeta().getAttributeModifiers(Attribute.LUCK).iterator().next()).getAmount();
        ItemMeta itemMeta = new ItemStack(note.getType()).getItemMeta();
        NamespacedKey noteIdentifier = new NamespacedKey((Plugin)this.plugin, "noteIdentifier");
        NamespacedKey noteValue = new NamespacedKey((Plugin)this.plugin, "noteValue");
        itemMeta.getPersistentDataContainer().set(noteIdentifier, PersistentDataType.STRING, (Object)NFCConfig.NOTE_UUID.getString());
        itemMeta.getPersistentDataContainer().set(noteValue, PersistentDataType.DOUBLE, (Object)money);
        itemMeta.setDisplayName(note.getItemMeta().getDisplayName());
        itemMeta.setLore(note.getItemMeta().getLore());
        itemMeta.setCustomModelData(Integer.valueOf(note.getItemMeta().getCustomModelData()));
        for (Map.Entry enchant : note.getEnchantments().entrySet()) {
            itemMeta.addEnchant((Enchantment)enchant.getKey(), ((Integer)enchant.getValue()).intValue(), true);
        }
        for (ItemFlag flag : note.getItemMeta().getItemFlags()) {
            itemMeta.addItemFlags(new ItemFlag[]{flag});
        }
        note.setItemMeta(itemMeta);
        Audience audience = this.plugin.getAdventure().player(p);
        audience.sendMessage(NFCMessages.NOTE_CONVERTED.getString());
    }
}

