/*
 * Decompiled with CFR 0.152.
 */
package es.kikisito.nfcnotes.enums;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.configuration.Configuration;

public enum NFCConfig {
    NOTE_NAME("notes.name", "<green>NFCNote</green>"),
    NOTE_LORE("notes.lore", Collections.singletonList("<gray>Value:</gray> <yellow>{money}$</yellow>")),
    NOTE_MATERIAL("notes.material", "PAPER"),
    NOTE_GLINT_ENABLED("notes.glint.enabled", false),
    NOTE_GLINT_HIDE_ENCHANTMENT_FLAG("notes.glint.hide-enchantment-flag", false),
    NOTE_GLINT_ENCHANTMENT("notes.glint.enchantment", "MENDING"),
    NOTE_GLINT_ENCHANTMENT_LEVEL("notes.glint.enchantment-level", 1),
    NOTE_DECIMAL_FORMAT("notes.decimal-format", "#,###.#"),
    NOTE_UUID("notes.identifier", "9a12cb32-1a7e-4e41-be79-9938528b4375"),
    NOTE_MAX_STACK_SIZE("notes.max-stack-size", 64),
    NOTE_CUSTOM_MODEL_DATA_INTEGER("notes.custom-model-data-integer", 2440573),
    USE_DECIMALS("notes.use-decimals", false),
    USE_EUROPEAN_FORMAT("notes.use-european-format", false),
    WITHDRAW_ONLY_ALLOWS_A_SPECIFIC_VALUE("notes.withdraw-only-allows-a-specific-value", false),
    WITHDRAW_VALUE("notes.withdraw-value", 100.0),
    REDEEM_SOUND_ENABLED("redeem-sound.enabled", true),
    REDEEM_SOUND("redeem-sound.sound", "BLOCK_CHAIN_BREAK"),
    REDEEM_SOUND_CATEGORY("redeem-sound.sound-category", "AMBIENT"),
    REDEEM_SOUND_VOLUME("redeem-sound.volume", 1.0),
    REDEEM_SOUND_PITCH("redeem-sound.pitch", 2.0),
    MODULES_WITHDRAW("modules.withdraw.base", true),
    MODULES_MULTIPLE_WITHDRAW("modules.withdraw.multiple-withdraw", true),
    MODULES_WITHDRAW_ALL("modules.withdraw.withdraw-all", true),
    MODULES_DEPOSIT_ACTION("modules.deposit.action.base", true),
    MODULES_MASSDEPOSIT("modules.deposit.action.massdeposit", true),
    MODULES_DEPOSIT_COMMAND("modules.deposit.command.deposit-one", true),
    MODULES_DEPOSIT_ONE("modules.deposit.command.deposit-all", true),
    MODULES_DEPOSIT_MULTIPLE("modules.deposit.command.deposit-multiple", true),
    MODULES_DEPOSIT_STACK("modules.deposit.command.deposit-stack", true),
    MODULES_WARN_STAFF("modules.warn-staff", true),
    MODULES_COUNT_SAME_PLAYER("modules.count.same-player", true),
    MODULES_COUNT_OTHER_PLAYERS("modules.count.other-players", true),
    SHOW_PLUGIN_INFO("show-plugin-info", true),
    ECONOMY_PLUGIN("economy-plugin", "Vault"),
    DISABLED_WORLDS("disabled-worlds", Collections.EMPTY_LIST),
    DISABLED_TABLES("disabled-tables", Collections.EMPTY_LIST),
    WARN_VALUE_LIMIT("warn-staff-if-value-is-higher-than", 100000),
    UPDATE_CHECKER_IS_ENABLED("update-checker.enable", true),
    UPDATE_CHECKER_NOTIFY_ON_JOIN("update-checker.notify-on-join", true),
    VERSION("config-version", 0);

    private final MiniMessage mm = MiniMessage.miniMessage();
    private static Configuration config;
    private final Object value;
    private final Object def;

    private NFCConfig(String value, String def) {
        this.value = value;
        this.def = def;
    }

    private NFCConfig(String value, int def) {
        this.value = value;
        this.def = def;
    }

    private NFCConfig(String value, double def) {
        this.value = value;
        this.def = def;
    }

    private NFCConfig(String value, boolean def) {
        this.value = value;
        this.def = def;
    }

    private NFCConfig(String value, List<String> def) {
        this.value = value;
        this.def = def;
    }

    public String getString() {
        return config.getString((String)this.value, (String)this.def);
    }

    public Component getMessage() {
        if (VERSION.getInt() < 13) {
            return LegacyComponentSerializer.legacyAmpersand().deserialize(config.getString((String)this.value, (String)this.def));
        }
        return this.mm.deserialize(config.getString((String)this.value, (String)this.def));
    }

    public int getInt() {
        return config.getInt((String)this.value, ((Integer)this.def).intValue());
    }

    public Double getDouble() {
        return config.getDouble((String)this.value, ((Double)this.def).doubleValue());
    }

    public boolean getBoolean() {
        return config.getBoolean((String)this.value, ((Boolean)this.def).booleanValue());
    }

    public List<String> getStrings() {
        return config.getStringList((String)this.value);
    }

    public List<Component> getMessages() {
        ArrayList<Component> components = new ArrayList<Component>();
        for (String s : config.getStringList((String)this.value)) {
            if (VERSION.getInt() < 13) {
                components.add(LegacyComponentSerializer.legacyAmpersand().deserialize(s));
                continue;
            }
            components.add((Component)this.mm.deserialize(s));
        }
        return components;
    }

    public static void setConfig(Configuration config) {
        NFCConfig.config = config;
    }
}

