/*
 * Decompiled with CFR 0.152.
 */
package es.kikisito.nfcnotes.commands;

import es.kikisito.nfcnotes.Main;
import es.kikisito.nfcnotes.NFCNote;
import es.kikisito.nfcnotes.enums.ActionMethod;
import es.kikisito.nfcnotes.enums.NFCConfig;
import es.kikisito.nfcnotes.enums.NFCMessages;
import es.kikisito.nfcnotes.events.WithdrawEvent;
import es.kikisito.nfcnotes.utils.Utils;
import java.text.DecimalFormat;
import net.kyori.adventure.audience.Audience;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;

public class Withdraw
implements CommandExecutor {
    private final Main plugin;

    public Withdraw(Main plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull @NotNull String @NotNull [] args) {
        if (!(sender instanceof Player)) {
            this.plugin.getAdventure().sender(sender).sendMessage(NFCMessages.ONLY_PLAYERS.getString());
            return false;
        }
        Player player = (Player)sender;
        Audience audience = this.plugin.getAdventure().sender((CommandSender)player);
        if (player.getInventory().firstEmpty() == -1) {
            audience.sendMessage(NFCMessages.FULL_INVENTORY.getString());
            return false;
        }
        if (NFCConfig.DISABLED_WORLDS.getStrings().contains(player.getWorld().getName()) && !player.hasPermission("nfcnotes.staff.withdraw.bypass.disabled-world")) {
            audience.sendMessage(NFCMessages.DISABLED_WORLD.getString());
            return false;
        }
        try {
            switch (args.length) {
                case 0: {
                    if (!NFCConfig.WITHDRAW_ONLY_ALLOWS_A_SPECIFIC_VALUE.getBoolean()) {
                        audience.sendMessage(NFCMessages.WITHDRAW_USAGE.getString());
                        break;
                    }
                    if (player.hasPermission("nfcnotes.withdraw.one")) {
                        double money = NFCConfig.WITHDRAW_VALUE.getDouble();
                        this.withdraw(player, money, 1);
                        break;
                    }
                    audience.sendMessage(NFCMessages.NO_PERMISSION.getString());
                    break;
                }
                case 1: {
                    if (!NFCConfig.WITHDRAW_ONLY_ALLOWS_A_SPECIFIC_VALUE.getBoolean()) {
                        if (args[0].equalsIgnoreCase("all")) {
                            if (NFCConfig.MODULES_WITHDRAW_ALL.getBoolean()) {
                                if (player.hasPermission("nfcnotes.withdraw.all")) {
                                    double money = Utils.getPlayerBalance(this.plugin, player);
                                    this.withdraw(player, money, 1);
                                    return true;
                                }
                                audience.sendMessage(NFCMessages.NO_PERMISSION.getString());
                                break;
                            }
                            audience.sendMessage(NFCMessages.MODULE_DISABLED.getString());
                            break;
                        }
                        if (NFCConfig.MODULES_WITHDRAW.getBoolean()) {
                            if (player.hasPermission("nfcnotes.withdraw.one")) {
                                double money = Double.parseDouble(args[0].replace(',', '.'));
                                money = (double)Math.round(money * 100.0) / 100.0;
                                this.withdraw(player, money, 1);
                                break;
                            }
                            audience.sendMessage(NFCMessages.NO_PERMISSION.getString());
                            break;
                        }
                        audience.sendMessage(NFCMessages.MODULE_DISABLED.getString());
                        break;
                    }
                    if (player.hasPermission("nfcnotes.withdraw.one")) {
                        double money = NFCConfig.WITHDRAW_VALUE.getDouble();
                        int amount = Integer.parseInt(args[0]);
                        this.withdraw(player, money, amount);
                        break;
                    }
                    audience.sendMessage(NFCMessages.NO_PERMISSION.getString());
                    break;
                }
                case 2: {
                    if (NFCConfig.WITHDRAW_ONLY_ALLOWS_A_SPECIFIC_VALUE.getBoolean()) {
                        audience.sendMessage(NFCMessages.WITHDRAW_USAGE.getString());
                        break;
                    }
                    if (player.hasPermission("nfcnotes.withdraw.multiple")) {
                        if (NFCConfig.MODULES_MULTIPLE_WITHDRAW.getBoolean()) {
                            double money = Double.parseDouble(args[0].replace(',', '.'));
                            money = (double)Math.round(money * 100.0) / 100.0;
                            int amount = Integer.parseInt(args[1]);
                            this.withdraw(player, money, amount);
                        }
                        break;
                    }
                    audience.sendMessage(NFCMessages.NO_PERMISSION.getString());
                    break;
                }
                default: {
                    audience.sendMessage(NFCMessages.WITHDRAW_USAGE.getString());
                    break;
                }
            }
        }
        catch (NumberFormatException ex) {
            audience.sendMessage(NFCMessages.INCORRECT_FORMAT.getString());
        }
        return true;
    }

    private void withdraw(Player p, double m, int a) {
        Audience audience = this.plugin.getAdventure().sender((CommandSender)p);
        if (m <= 0.0) {
            audience.sendMessage(NFCMessages.USE_A_NUMBER_HIGHER_THAN_ZERO.getString());
            return;
        }
        if (m % 1.0 != 0.0 && !NFCConfig.USE_DECIMALS.getBoolean()) {
            audience.sendMessage(NFCMessages.ONLY_INTEGERS.getString());
            return;
        }
        int freeSlots = this.countFreeSlots(p.getInventory());
        if (a > 64 && freeSlots < (int)Math.ceil((double)a / 64.0)) {
            audience.sendMessage(NFCMessages.NOT_ENOUGH_SPACE.getString());
            return;
        }
        WithdrawEvent withdrawEvent = new WithdrawEvent(p, m, a, ActionMethod.COMMAND);
        this.plugin.getServer().getPluginManager().callEvent((Event)withdrawEvent);
        if (!withdrawEvent.isCancelled()) {
            Player player = withdrawEvent.getPlayer();
            Audience playerAudience = this.plugin.getAdventure().sender((CommandSender)player);
            Double money = withdrawEvent.getMoney();
            Integer amount = withdrawEvent.getAmount();
            DecimalFormat decimalFormat = Utils.getDecimalFormat();
            String formattedMoney = decimalFormat.format(money * (double)amount.intValue());
            if (Utils.getPlayerBalance(this.plugin, player) >= money * (double)amount.intValue()) {
                if (Utils.withdrawSuccessful(this.plugin, player, money * (double)amount.intValue())) {
                    ItemStack paper = NFCNote.createNFCNoteItem(this.plugin, NFCConfig.NOTE_NAME.getMessage(), NFCConfig.NOTE_LORE.getMessages(), NFCConfig.NOTE_MATERIAL.getString(), p.getName(), decimalFormat, money, amount);
                    player.getInventory().addItem(new ItemStack[]{paper});
                    playerAudience.sendMessage(NFCMessages.WITHDRAW_SUCCESSFUL.getString("{money}", formattedMoney));
                    if (money * (double)amount.intValue() >= (double)NFCConfig.WARN_VALUE_LIMIT.getInt() && NFCConfig.MODULES_WARN_STAFF.getBoolean()) {
                        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
                            if (!pl.hasPermission("nfcnotes.staff.warn") || player == pl) continue;
                            Audience staffAudience = this.plugin.getAdventure().sender((CommandSender)pl);
                            staffAudience.sendMessage(NFCMessages.STAFF_WARN_WITHDRAW.getString("{player}", player.getName(), "{money}", formattedMoney));
                            this.plugin.getLogger().info(NFCMessages.STAFF_WARN_WITHDRAW.getLegacyString("{player}", player.getName(), "{money}", formattedMoney));
                        }
                    }
                } else {
                    playerAudience.sendMessage(NFCMessages.UNEXPECTED_ERROR.getString());
                }
            } else {
                playerAudience.sendMessage(NFCMessages.INSUFFICIENT_FUNDS.getString());
            }
        }
    }

    private int countFreeSlots(PlayerInventory inventory) {
        int freeSlots = 0;
        for (ItemStack item : inventory.getStorageContents()) {
            if (item != null) continue;
            ++freeSlots;
        }
        return freeSlots;
    }
}

